/*
 * Decompiled with CFR 0.152.
 */
package com.thorstenfischer.util;

import com.thorstenfischer.util.Paintable;
import com.thorstenfischer.util.Util;

public class Vertex
extends Paintable
implements Comparable<Vertex> {
    private boolean marked = false;
    private double x;
    private double y;

    public static double distance(Vertex v1, Vertex v2) {
        if (v1 == null || v2 == null) {
            throw new NullPointerException();
        }
        return Math.sqrt(Math.pow(v2.getX() - v1.getX(), 2.0) + Math.pow(v2.getY() - v1.getY(), 2.0));
    }

    public Vertex(double x, double y) {
        this.x = x;
        this.y = y;
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public boolean isMarked() {
        return this.marked;
    }

    public void setMarked(boolean marked) {
        this.marked = marked;
    }

    @Override
    public int compareTo(Vertex v) {
        if (this.equals(v)) {
            return 0;
        }
        if (v.getX() != this.getX()) {
            return this.getX() < v.getX() ? -1 : 1;
        }
        return this.getY() < v.getY() ? -1 : 1;
    }

    public boolean equals(Object o) {
        if (o == null) {
            throw new NullPointerException();
        }
        if (!(o instanceof Vertex)) {
            return false;
        }
        Vertex v = (Vertex)o;
        return Util.isEqual(v.getX(), this.x) && Util.isEqual(v.getY(), this.y);
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public String toString() {
        return String.valueOf((int)this.x) + "|" + (int)this.y;
    }
}

