/*
 * Decompiled with CFR 0.152.
 */
package com.thorstenfischer.util;

import com.thorstenfischer.util.Edge;
import com.thorstenfischer.util.Vertex;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;

public class Graph {
    private TreeSet<Vertex> vS = new TreeSet();
    private TreeSet<Edge> eS = new TreeSet();
    private TreeMap<Vertex, Set<Edge>> adj = new TreeMap();
    private double minX = Double.MAX_VALUE;
    private double minY = Double.MAX_VALUE;
    private double maxX = Double.MIN_VALUE;
    private double maxY = Double.MIN_VALUE;

    public boolean addVertex(Vertex v) {
        if (v == null) {
            throw new NullPointerException();
        }
        boolean ret = this.vS.add(v);
        if (ret) {
            double x = v.getX();
            double y = v.getY();
            if (x < this.minX) {
                this.minX = x;
            }
            if (x > this.maxX) {
                this.maxX = x;
            }
            if (y < this.minY) {
                this.minY = y;
            }
            if (y > this.maxY) {
                this.maxY = y;
            }
        }
        return ret;
    }

    public Edge addEdge(Vertex v1, Vertex v2, boolean directed) {
        Edge e;
        if (v1 == null || v2 == null) {
            throw new NullPointerException();
        }
        if (!this.vS.contains(v1)) {
            this.addVertex(v1);
        }
        if (!this.vS.contains(v2)) {
            this.addVertex(v2);
        }
        if (!this.eS.add(e = new Edge(v1, v2, directed))) {
            e = this.eS.ceiling(e);
        }
        Vertex aV = v1;
        int i = 0;
        while (i <= (directed ? 1 : 2)) {
            Set<Edge> s = this.adj.get(aV);
            if (s == null) {
                s = new TreeSet<Edge>();
            }
            s.add(e);
            this.adj.put(aV, s);
            if (!directed) {
                aV = v2;
            }
            ++i;
        }
        return e;
    }

    public Edge addEdge(Edge e) {
        if (e == null) {
            throw new NullPointerException();
        }
        return this.addEdge(e.getV1(), e.getV2(), e.isDirected());
    }

    public void print(PrintStream out, boolean verbose) {
        if (verbose) {
            out.println("Die Knotenliste (" + this.vS.size() + " St\u00fcck) :");
            for (Vertex v : this.vS) {
                out.println(v + (v.isMarked() ? " marked" : " unmarked"));
            }
            out.println("Die Kantenliste (" + this.eS.size() + " St\u00fcck) :");
            for (Edge e : this.eS) {
                out.println(e + (e.isMarked() ? " marked" : " unmarked"));
            }
        }
        out.println("Die Adjazenzliste");
        for (Vertex v : this.adj.keySet()) {
            out.print("Knoten: " + v + ": ");
            for (Edge e : this.adj.get(v)) {
                out.print(String.valueOf(e.toString(v)) + "; ");
            }
            out.println();
        }
    }

    public Edge addEdge(Vertex v1, Vertex v2) {
        return this.addEdge(v1, v2, false);
    }

    public void unmarkAll() {
        this.unmarkEdges();
        this.unmarkVertex();
    }

    public void unmarkEdges() {
        for (Edge e : this.eS) {
            e.setMarked(false);
        }
    }

    public void unmarkVertex() {
        for (Vertex v : this.vS) {
            v.setMarked(false);
        }
    }

    public int getCountEdges(boolean marked) {
        int i = 0;
        if (this.eS == null) {
            return 0;
        }
        for (Edge e : this.eS) {
            if (e.isMarked() != marked) continue;
            ++i;
        }
        return i;
    }

    public int getCountEdges(Vertex v, boolean marked) {
        int i = 0;
        Set<Edge> adjE = this.getAdjEdges(v);
        if (adjE == null) {
            return 0;
        }
        for (Edge e : adjE) {
            if (e.isMarked() != marked) continue;
            ++i;
        }
        return i;
    }

    public int getCountMinV(Vertex v, boolean marked) {
        int i = Integer.MAX_VALUE;
        Set<Edge> adjE = this.getAdjEdges(v);
        if (adjE == null) {
            return 0;
        }
        for (Edge e : adjE) {
            int anz = this.getCountEdges(e.getDestVertex(v), marked);
            if (anz >= i) continue;
            i = anz;
        }
        return i;
    }

    public int getCountMinMarkedV(Vertex v, boolean markedV, boolean markedE) {
        int i = Integer.MAX_VALUE;
        Set<Vertex> adjV = this.getAdjVertex(v, markedV);
        if (adjV == null) {
            return 0;
        }
        for (Vertex iV : adjV) {
            int anz = this.getCountEdges(iV, markedE);
            if (anz >= i) continue;
            i = anz;
        }
        return i;
    }

    public int getCountVertex(boolean marked) {
        int i = 0;
        for (Vertex v : this.vS) {
            if (v.isMarked() != marked) continue;
            ++i;
        }
        return i;
    }

    public int getCountVertex(Vertex v, boolean marked) {
        int i = 0;
        Set<Edge> adjE = this.getAdjEdges(v);
        for (Edge iE : adjE) {
            if (iE.getDestVertex(v).isMarked() != marked) continue;
            ++i;
        }
        return i;
    }

    public int getCountEdges() {
        return this.eS.size();
    }

    public int getCountVertex() {
        return this.vS.size();
    }

    public TreeSet<Vertex> getVS() {
        return this.vS;
    }

    public double getMaxY() {
        return this.maxY;
    }

    public double getMinX() {
        return this.minX;
    }

    public double getMaxX() {
        return this.maxX;
    }

    public double getMinY() {
        return this.minY;
    }

    public TreeSet<Edge> getES() {
        return this.eS;
    }

    public Set<Edge> getAdjEdges(Vertex v) {
        Set<Edge> ret = this.adj.get(v);
        if (ret == null) {
            return null;
        }
        if (ret.size() == 0) {
            return null;
        }
        return ret;
    }

    public Set<Edge> getAdjEdges(Vertex v, boolean marked) {
        Set<Edge> ret = this.adj.get(v);
        if (ret == null) {
            return null;
        }
        if (ret.size() == 0) {
            return null;
        }
        TreeSet<Edge> founds = new TreeSet<Edge>();
        for (Edge iE : ret) {
            if (iE.isMarked() != marked) continue;
            founds.add(iE);
        }
        if (founds == null) {
            return null;
        }
        if (founds.size() == 0) {
            return null;
        }
        return founds;
    }

    public Set<Vertex> getAdjVertex(Vertex v) {
        Set<Edge> adjEdge = this.getAdjEdges(v);
        if (adjEdge == null) {
            return null;
        }
        TreeSet<Vertex> adjV = new TreeSet<Vertex>();
        for (Edge e : adjEdge) {
            adjV.add(e.getDestVertex(v));
        }
        if (adjV.size() == 0) {
            return null;
        }
        return adjV;
    }

    public Set<Vertex> getAdjVertex(Vertex v, boolean marked) {
        Set<Edge> adjEdge = this.getAdjEdges(v);
        if (adjEdge == null) {
            return null;
        }
        TreeSet<Vertex> adjV = new TreeSet<Vertex>();
        for (Edge e : adjEdge) {
            Vertex aV = e.getDestVertex(v);
            if (!aV.isMarked()) continue;
            adjV.add(aV);
        }
        if (adjV.size() == 0) {
            return null;
        }
        return adjV;
    }

    public boolean contains(Vertex v) {
        return this.vS.contains(v);
    }

    public boolean contains(Edge e) {
        return this.eS.contains(e);
    }

    public Vertex getVertex(double x, double y) {
        Vertex sV = new Vertex(x, y);
        Vertex v = this.vS.ceiling(sV);
        if (!v.equals(sV)) {
            return null;
        }
        return v;
    }

    public List<Vertex> getVertex(boolean marked) {
        ArrayList<Vertex> ret = new ArrayList<Vertex>();
        for (Vertex iV : this.vS) {
            if (iV.isMarked() != marked) continue;
            ret.add(iV);
        }
        if (ret.size() == 0) {
            return null;
        }
        return ret;
    }

    public List<Edge> getEdge(boolean marked) {
        ArrayList<Edge> ret = new ArrayList<Edge>();
        for (Edge iE : this.eS) {
            if (iE.isMarked() != marked) continue;
            ret.add(iE);
        }
        if (ret.size() == 0) {
            return null;
        }
        return ret;
    }

    public boolean deleteEdge(Edge e) {
        Set<Edge> v2S;
        if (e == null) {
            throw new NullPointerException();
        }
        Vertex v1 = e.getV1();
        Vertex v2 = e.getV2();
        boolean ret = this.eS.remove(e);
        Set<Edge> v1S = this.adj.get(v1);
        if (v1S != null) {
            v1S.remove(e);
        }
        if ((v2S = this.adj.get(v2)) != null) {
            v2S.remove(e);
        }
        return ret;
    }

    public void deleteAdjEdges(Vertex v, boolean markedE) {
        Set<Edge> rm = null;
        rm = this.getAdjEdges(v, markedE);
        if (rm != null) {
            for (Edge iE : rm) {
                this.deleteEdge(iE);
            }
        }
    }

    public boolean deleteUnmarkedEdges() {
        List<Edge> mE = this.getEdge(false);
        boolean success = true;
        for (Edge iE : mE) {
            boolean bl = success = success && this.deleteEdge(iE);
        }
        return success;
    }

    public void setEdgesAll(boolean cartesianOnly) {
        TreeSet<Edge> eAll = new TreeSet<Edge>();
        TreeSet<Edge> eFound = new TreeSet<Edge>();
        TreeSet<Vertex> vS = this.getVS();
        for (Vertex v1 : vS) {
            for (Vertex v2 : vS.tailSet(v1, false)) {
                Edge e = new Edge(v1, v2);
                if (!cartesianOnly) {
                    eAll.add(e);
                    continue;
                }
                if (!e.isCartesian()) continue;
                eAll.add(e);
            }
        }
        for (Edge e1 : eAll) {
            boolean cuts = false;
            for (Edge e2 : eFound) {
                if (!e1.cuts(e2)) continue;
                cuts = true;
                break;
            }
            if (cuts) continue;
            eFound.add(e1);
        }
        for (Edge e : eFound) {
            this.addEdge(e);
        }
    }

    public void setVertexRandom(Random r, int minX, int minY, int maxX, int maxY, int anz) {
        int i = 0;
        while (i < anz) {
            Vertex v;
            while (!this.addVertex(v = new Vertex(r.nextInt(Math.abs(maxX - minX + 1)) + minX, r.nextInt(Math.abs(maxY - minY + 1)) + minY))) {
            }
            ++i;
        }
    }

    public void setVertexChecked(int anzX, int anzY) {
        int x = 1;
        while (x <= anzX) {
            int y = 1;
            while (y <= anzY) {
                this.addVertex(new Vertex(x, y));
                ++y;
            }
            ++x;
        }
    }

    public boolean existsEdge(double v1x, double v1y, double v2x, double v2y) {
        Vertex v1 = new Vertex(v1x, v1y);
        Vertex v2 = new Vertex(v2x, v2y);
        Edge e = new Edge(v1, v2);
        return this.contains(e);
    }
}

