/*
 * Decompiled with CFR 0.152.
 */
package com.thorstenfischer.util;

import com.thorstenfischer.util.Paintable;
import com.thorstenfischer.util.Util;
import com.thorstenfischer.util.Vertex;

public class Edge
extends Paintable
implements Comparable<Edge> {
    private double weight = 0.0;
    private double a;
    private double b;
    private Vertex v1;
    private Vertex v2;
    private boolean directed = false;
    private boolean marked = false;

    public Edge(Vertex v1, Vertex v2, boolean directed) {
        if (v1 == null || v2 == null) {
            throw new NullPointerException();
        }
        if (v1.equals(v2)) {
            throw new IllegalArgumentException("Kante zwischen identischen Knoten");
        }
        this.weight = Vertex.distance(v1, v2);
        this.v1 = v1;
        this.v2 = v2;
        this.directed = directed;
        if (v2.getX() - v1.getX() == 0.0) {
            this.a = Double.NaN;
            this.b = v1.getX();
        } else {
            this.a = (v2.getY() - v1.getY()) / (v2.getX() - v1.getX());
            this.b = v1.getY() - v1.getX() * this.a;
        }
    }

    public Edge(Vertex v1, Vertex v2) {
        this(v1, v2, false);
    }

    @Override
    public int compareTo(Edge e) {
        if (this.equals(e)) {
            return 0;
        }
        if (this.isDirected() != e.isDirected()) {
            return this.isDirected() ? -1 : 1;
        }
        if (this.getWeight() != e.getWeight()) {
            return this.getWeight() < e.getWeight() ? -1 : 1;
        }
        if (this.isDirected()) {
            if (!this.getV1().equals(e.getV1())) {
                return this.getV1().compareTo(e.getV1());
            }
            return this.getV2().compareTo(e.getV2());
        }
        Vertex vke = e.getLesserVertex();
        Vertex vge = e.getGreaterVertex();
        Vertex vkt = this.getLesserVertex();
        Vertex vgt = this.getGreaterVertex();
        if (!vkt.equals(vke)) {
            return vkt.compareTo(vke);
        }
        return vgt.compareTo(vge);
    }

    public Vertex getLesserVertex() {
        return this.v1.compareTo(this.v2) < 0 ? this.v1 : this.v2;
    }

    public Vertex getGreaterVertex() {
        return this.v1.compareTo(this.v2) > 0 ? this.v1 : this.v2;
    }

    public double getWeight() {
        return this.weight;
    }

    public boolean equals(Object o) {
        if (o == null) {
            throw new NullPointerException();
        }
        if (!(o instanceof Edge)) {
            return false;
        }
        Edge e = (Edge)o;
        if (e.isDirected() != this.directed) {
            return false;
        }
        if (this.directed) {
            return this.v1.equals(e.getV1()) && this.v2.equals(e.getV2());
        }
        return this.v1.equals(e.getV1()) && this.v2.equals(e.getV2()) || this.v1.equals(e.getV2()) && this.v2.equals(e.getV1());
    }

    private String toShortString() {
        return String.valueOf(this.v1.toString()) + (this.directed ? "->" : "<->") + this.v2.toString();
    }

    private String toShortString(Vertex srcNode) {
        String ret = this.toShortString();
        ret = this.v1.equals(srcNode) ? String.valueOf(ret) + "Z" : "Z" + ret;
        return ret;
    }

    private String toLongString(String shortS) {
        return "(" + shortS + ";" + String.format("%.2f", this.weight) + ")";
    }

    public String toString() {
        return this.toLongString(this.toShortString());
    }

    public String toString(Vertex v) {
        return this.toLongString(this.toShortString(v));
    }

    public boolean isDirected() {
        return this.directed;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public Vertex getV1() {
        return this.v1;
    }

    public Vertex getV2() {
        return this.v2;
    }

    public double getA() {
        return this.a;
    }

    public double getB() {
        return this.b;
    }

    public Vertex getDestVertex(Vertex srcVertex) {
        if (srcVertex == null) {
            throw new NullPointerException();
        }
        if (this.v1.equals(srcVertex)) {
            return this.v2;
        }
        if (!this.directed && this.v2.equals(srcVertex)) {
            return this.v1;
        }
        throw new IllegalArgumentException(String.valueOf(srcVertex.toString()) + " nicht in " + this.toString());
    }

    public Vertex getSrcVertex(Vertex destVertex) {
        if (destVertex == null) {
            throw new NullPointerException();
        }
        if (this.v2.equals(destVertex)) {
            return this.v1;
        }
        if (!this.directed && this.v1.equals(destVertex)) {
            return this.v2;
        }
        throw new IllegalArgumentException(String.valueOf(destVertex.toString()) + " nicht in " + this.toString());
    }

    public static boolean intervalsIntersect(double a, double b, double c, double d) {
        double h;
        if (a > b) {
            h = a;
            a = b;
            b = h;
        }
        if (c > d) {
            h = c;
            c = d;
            d = h;
        }
        if (a > c) {
            h = a;
            a = c;
            c = h;
            h = b;
            b = d;
            d = h;
        }
        return Util.isLesser(c, b);
    }

    public static boolean iInIntervals(double i1, double i1a, double i1b, double i2, double i2a, double i2b) {
        double h;
        if (i1a > i1b) {
            h = i1a;
            i1a = i1b;
            i1b = h;
        }
        if (i2a > i2b) {
            h = i2a;
            i2a = i2b;
            i2b = h;
        }
        return Util.isLesser(i1a, i1) && Util.isLesser(i1, i1b) && Util.isLesser(i2a, i2) && Util.isLesser(i2, i2b);
    }

    public boolean cuts(Edge e) {
        double i2b;
        double i2a;
        double i2;
        double i1b;
        double i1a;
        double i1;
        if (e == null) {
            throw new NullPointerException();
        }
        if (this.equals(e)) {
            return true;
        }
        double c = e.getA();
        double d = e.getB();
        double m = this.a;
        double f = this.b;
        if (c == m || Double.isNaN(c) && Double.isNaN(m)) {
            double i2b2;
            double i2a2;
            double i1b2;
            double i1a2;
            if (d != f) {
                return false;
            }
            if (Double.isNaN(m)) {
                i1a2 = this.v1.getY();
                i1b2 = this.v2.getY();
                i2a2 = e.getV1().getY();
                i2b2 = e.getV2().getY();
            } else {
                i1a2 = this.v1.getX();
                i1b2 = this.v2.getX();
                i2a2 = e.getV1().getX();
                i2b2 = e.getV2().getX();
            }
            return Edge.intervalsIntersect(i1a2, i1b2, i2a2, i2b2);
        }
        if (Double.isNaN(c) && m == 0.0) {
            double sy;
            double sx = e.getB();
            i1 = sy = this.getB();
            i1a = e.getV1().getY();
            i1b = e.getV2().getY();
            i2 = sx;
            i2a = this.v1.getX();
            i2b = this.v2.getX();
        } else if (c == 0.0 && Double.isNaN(m)) {
            double sy;
            double sx = this.getB();
            i1 = sy = e.getB();
            i1a = this.v1.getY();
            i1b = this.v2.getY();
            i2 = sx;
            i2a = e.getV1().getX();
            i2b = e.getV2().getX();
        } else if (Double.isNaN(c) && m != 0.0) {
            double sy;
            double sx = d;
            i1 = sy = m * sx + f;
            i1a = e.getV1().getY();
            i1b = e.getV2().getY();
            i2 = sx;
            i2a = this.v1.getX();
            i2b = this.v2.getX();
        } else if (Double.isNaN(m) && c != 0.0) {
            double sy;
            double sx = f;
            i1 = sy = c * sx + d;
            i1a = this.v1.getY();
            i1b = this.v2.getY();
            i2 = sx;
            i2a = e.getV1().getX();
            i2b = e.getV2().getX();
        } else {
            double sx = (d - f) / (m - c);
            double sy = m * sx + f;
            i1 = sx;
            i1a = this.v1.getX();
            i1b = this.v2.getX();
            i2 = sx;
            i2a = e.getV1().getX();
            i2b = e.getV2().getX();
        }
        return Edge.iInIntervals(i1, i1a, i1b, i2, i2a, i2b);
    }

    public boolean isCartesian() {
        return Double.isNaN(this.a) || Util.isEqual(this.a, 0.0);
    }

    public boolean isMarked() {
        return this.marked;
    }

    public void setMarked(boolean marked) {
        this.marked = marked;
    }
}

