/*
 * Decompiled with CFR 0.152.
 */
package com.thorstenfischer.ui;

import com.thorstenfischer.util.Edge;
import com.thorstenfischer.util.Graph;
import com.thorstenfischer.util.Vertex;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JPanel;

public class GraphPanel
extends JPanel
implements Printable {
    private static final long serialVersionUID = 1L;
    private List<Graph> gS = new ArrayList<Graph>();
    private double maxX;
    private double maxY;
    private double minX;
    private double minY;
    public static final int RAND = 30;
    private boolean isPrinting = false;
    private boolean doPainting = true;

    private GraphPanel() {
    }

    public GraphPanel(Graph graph) {
        this.setOpaque(true);
        this.setBackground(Color.WHITE);
        this.setGraph(graph);
    }

    public void setGraph(Graph graph) {
        if (graph == null) {
            throw new NullPointerException();
        }
        this.gS = new ArrayList<Graph>();
        this.gS.add(graph);
        this.minX = Math.min(this.minX, graph.getMinX());
        this.minY = Math.min(this.minY, graph.getMinY());
        this.maxX = Math.max(this.maxX, graph.getMaxX());
        this.maxY = Math.max(this.maxY, graph.getMaxY());
    }

    public double getMaxX() {
        return this.maxX;
    }

    public void setMaxX(double maxX) {
        this.maxX = maxX;
    }

    public double getMaxY() {
        return this.maxY;
    }

    public void setMaxY(double maxY) {
        this.maxY = maxY;
    }

    public double getMinX() {
        return this.minX;
    }

    public void setMinX(double minX) {
        this.minX = minX;
    }

    public double getMinY() {
        return this.minY;
    }

    public void setMinY(double minY) {
        this.minY = minY;
    }

    public boolean isPrinting() {
        return this.isPrinting;
    }

    public void setPrinting(boolean isPrinting) {
        this.isPrinting = isPrinting;
    }

    public boolean doPainting() {
        return this.doPainting;
    }

    public void setDoPainting(boolean doPainting) {
        this.doPainting = doPainting;
    }

    public int scX(double x) {
        double width = this.getSize().width - 60;
        return (int)(width / (this.getMaxX() - this.getMinX()) * (x - this.getMinX())) + 30;
    }

    public int scY(double y) {
        double height = this.getSize().height - 60;
        double newY = height / (this.getMaxY() - this.getMinY()) * (y - this.getMinY());
        newY = height - newY;
        return (int)newY + 30;
    }

    public void dL(Graphics2D g, double x, double y, double x1, double y1) {
        g.drawLine(this.scX(x), this.scY(y), this.scX(x1), this.scY(y1));
    }

    private void paintGraph(Graph graph, Graphics2D g) {
        for (Vertex v : graph.getVS()) {
            g.setColor(v.getColor());
            int vx = this.scX(v.getX()) - v.getThick();
            int vy = this.scY(v.getY()) - v.getThick();
            g.fillOval(vx, vy, v.getThick() * 2, v.getThick() * 2);
            g.drawString(v.toString(), vx, vy);
        }
        for (Edge e : graph.getES()) {
            if (e.getColor() == Color.GREEN) continue;
            g.setColor(e.getColor());
            this.dL(g, e.getV1().getX(), e.getV1().getY(), e.getV2().getX(), e.getV2().getY());
        }
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        Graphics2D g2d = (Graphics2D)g;
        if (this.doPainting()) {
            for (Graph graph : this.gS) {
                this.paintGraph(graph, g2d);
                if (!this.isPrinting()) continue;
                this.paintForPrint(g2d);
            }
        }
    }

    public void paintForPrint(Graphics2D g2d) {
    }

    @Override
    public int print(Graphics g, PageFormat pf, int page) throws PrinterException {
        if (page > 0) {
            return 1;
        }
        Graphics2D g2d = (Graphics2D)g;
        g2d.translate(pf.getImageableX(), pf.getImageableY());
        double px = 0.027777777777777776;
        g2d.scale((pf.getImageableWidth() - px) / (double)this.getWidth(), (pf.getImageableHeight() - px) / (double)this.getHeight());
        this.isPrinting = true;
        this.print(g);
        this.isPrinting = false;
        return 0;
    }
}

