/*
 * Decompiled with CFR 0.152.
 */
package com.thorstenfischer.labyrinth.ui;

import com.thorstenfischer.labyrinth.LabyGraph;
import com.thorstenfischer.labyrinth.LabyParam;
import com.thorstenfischer.labyrinth.ui.LabyGraphPanel;
import com.thorstenfischer.labyrinth.ui.LabyParamDlg;
import com.thorstenfischer.ui.Util;
import com.thorstenfischer.ui.WState;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JRadioButton;
import javax.swing.JToggleButton;
import javax.swing.SwingWorker;

public class MainFrame
extends JFrame {
    private static final long serialVersionUID = 1L;
    private static final int STATUS_CODE = 1;
    private JPanel jContentPane = null;
    private JPanel pnlMain = null;
    private LabyGraph graph = null;
    private JPanel pnlButtons = null;
    private JButton cmdParams = null;
    private JPanel pnlStatusbar = null;
    private JToggleButton optShowLsg = null;
    private JButton cmdPrint = null;
    private JPanel pnlService = null;
    private JPanel pnlRandom = null;
    private JRadioButton optHoch = null;
    private JRadioButton optQuer = null;
    private JRadioButton optGross = null;
    private JRadioButton optKlein = null;
    private JButton cmdGenRnd = null;
    private ButtonGroup btgGroesse = null;
    private ButtonGroup btgAusrichtung = null;
    private JProgressBar pgbProgressBar = null;
    private GenLabyTask genLabyTask = null;

    private MainFrame() {
        this.initialize();
    }

    public MainFrame(LabyGraph g) {
        this.graph = g;
        this.initialize();
        this.myInitialize();
        this.initGUI();
    }

    public void initGUI() {
        this.displayStatus(1);
        this.initOptVordefGr();
    }

    private void initialize() {
        this.setContentPane(this.getJContentPane());
        this.setSize(610, 333);
        this.setIconImage(Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/com/thorstenfischer/labyrinth/ui/Icon.gif")));
        this.setTitle("Labyrinth");
    }

    private void myInitialize() {
        this.btgGroesse = new ButtonGroup();
        this.btgGroesse.add(this.optGross);
        this.btgGroesse.add(this.optKlein);
        this.btgAusrichtung = new ButtonGroup();
        this.btgAusrichtung.add(this.optHoch);
        this.btgAusrichtung.add(this.optQuer);
        this.setSize(700, 500);
        Util.center(this);
    }

    private void initOptVordefGr() {
        LabyParam p = this.graph.getParams();
        if (p.getVordefGr() != null) {
            if (p.getAusrichtung() == LabyParam.Ausrichtung.HOCH) {
                this.optHoch.setSelected(true);
            } else {
                this.optQuer.setSelected(true);
            }
            if (p.getGroesse() == LabyParam.Groesse.GROSS) {
                this.optGross.setSelected(true);
            } else {
                this.optKlein.setSelected(true);
            }
        } else {
            this.btgGroesse.clearSelection();
            this.btgAusrichtung.clearSelection();
        }
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new BorderLayout());
            this.jContentPane.add((Component)this.getPnlMain(), "Center");
            this.jContentPane.add((Component)this.getPnlStatusbar(), "South");
            this.jContentPane.add((Component)this.getPnlService(), "North");
        }
        return this.jContentPane;
    }

    private JPanel getPnlMain() {
        if (this.pnlMain == null) {
            this.pnlMain = new LabyGraphPanel(this.graph);
            this.pnlMain.setLayout(new GridBagLayout());
        }
        return this.pnlMain;
    }

    @Override
    public void setVisible(boolean arg0) {
        super.setVisible(arg0);
        if (!arg0) {
            System.exit(0);
        }
    }

    private JPanel getPnlButtons() {
        if (this.pnlButtons == null) {
            this.pnlButtons = new JPanel();
            this.pnlButtons.setLayout(new FlowLayout());
            this.pnlButtons.add((Component)this.getCmdParams(), null);
            this.pnlButtons.add((Component)this.getOptShowLsg(), null);
            this.pnlButtons.add((Component)this.getCmdPrint(), null);
        }
        return this.pnlButtons;
    }

    private JButton getCmdParams() {
        if (this.cmdParams == null) {
            this.cmdParams = new JButton();
            this.cmdParams.setName("cmdParams");
            this.cmdParams.setText("Parameter...");
            this.cmdParams.setToolTipText("Parameter des Labyrinths \u00e4ndern");
            this.cmdParams.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MainFrame.this.cmdParams_actionPerformed();
                }
            });
        }
        return this.cmdParams;
    }

    private void cmdParams_actionPerformed() {
        LabyParamDlg dlg = new LabyParamDlg((Frame)this, this.graph.getParams());
        dlg.pack();
        dlg.setResizable(false);
        dlg.setVisible(true);
        if (dlg.getWState() == WState.OK) {
            this.newLaby(dlg.getParams());
        }
        this.initOptVordefGr();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void displayStatus(Object o) {
        String s = null;
        if (o instanceof Integer) {
            int i = (Integer)o;
            if (i != 1) throw new IllegalArgumentException();
            this.pgbProgressBar.setString("Code: " + this.graph.getParams().toString());
            return;
        } else {
            if (!(o instanceof String)) throw new IllegalArgumentException();
            s = (String)o;
            this.pgbProgressBar.setString(s);
        }
    }

    private JPanel getPnlStatusbar() {
        if (this.pnlStatusbar == null) {
            GridLayout gridLayout = new GridLayout();
            gridLayout.setRows(1);
            this.pnlStatusbar = new JPanel();
            this.pnlStatusbar.setBorder(BorderFactory.createBevelBorder(1));
            this.pnlStatusbar.setLayout(gridLayout);
            this.pnlStatusbar.add((Component)this.getPgbProgressBar(), null);
        }
        return this.pnlStatusbar;
    }

    private JToggleButton getOptShowLsg() {
        if (this.optShowLsg == null) {
            this.optShowLsg = new JToggleButton();
            this.optShowLsg.setName("optShowLsg");
            this.optShowLsg.setText("L\u00f6sung anzeigen");
            this.optShowLsg.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MainFrame.this.optShowLsg_actionPerformed();
                }
            });
        }
        return this.optShowLsg;
    }

    private void optShowLsg_actionPerformed() {
        ((LabyGraphPanel)this.pnlMain).setShowLsg(this.optShowLsg.isSelected());
        this.pnlMain.repaint();
    }

    private JButton getCmdPrint() {
        if (this.cmdPrint == null) {
            this.cmdPrint = new JButton();
            this.cmdPrint.setName("cmdPrint");
            this.cmdPrint.setText("Drucken...");
            this.cmdPrint.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MainFrame.this.cmdPrint_actionPerformed();
                }
            });
        }
        return this.cmdPrint;
    }

    private void cmdPrint_actionPerformed() {
        PrinterJob job = PrinterJob.getPrinterJob();
        job.setPrintable((LabyGraphPanel)this.pnlMain);
        boolean doPrint = job.printDialog();
        if (doPrint) {
            try {
                job.print();
            }
            catch (PrinterException printerException) {
                // empty catch block
            }
        }
    }

    private JPanel getPnlService() {
        if (this.pnlService == null) {
            this.pnlService = new JPanel();
            this.pnlService.setLayout(new FlowLayout());
            this.pnlService.add((Component)this.getPnlButtons(), null);
            this.pnlService.add((Component)this.getPnlRandom(), null);
        }
        return this.pnlService;
    }

    private JPanel getPnlRandom() {
        if (this.pnlRandom == null) {
            GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
            gridBagConstraints4.gridx = 3;
            gridBagConstraints4.gridheight = 2;
            gridBagConstraints4.gridy = 1;
            GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
            gridBagConstraints3.gridx = 2;
            gridBagConstraints3.gridy = 2;
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.gridx = 2;
            gridBagConstraints2.gridy = 1;
            GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
            gridBagConstraints1.gridx = 1;
            gridBagConstraints1.gridy = 2;
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 1;
            this.pnlRandom = new JPanel();
            this.pnlRandom.setLayout(new GridBagLayout());
            this.pnlRandom.add((Component)this.getOptHoch(), gridBagConstraints);
            this.pnlRandom.add((Component)this.getOptQuer(), gridBagConstraints1);
            this.pnlRandom.add((Component)this.getOptGross(), gridBagConstraints2);
            this.pnlRandom.add((Component)this.getOptKlein(), gridBagConstraints3);
            this.pnlRandom.add((Component)this.getCmdGenRnd(), gridBagConstraints4);
        }
        return this.pnlRandom;
    }

    private JRadioButton getOptHoch() {
        if (this.optHoch == null) {
            this.optHoch = new JRadioButton();
            this.optHoch.setName("optHoch");
            this.optHoch.setToolTipText("DIN A4 Hochkant");
            this.optHoch.setText("Hoch");
        }
        return this.optHoch;
    }

    private JRadioButton getOptQuer() {
        if (this.optQuer == null) {
            this.optQuer = new JRadioButton();
            this.optQuer.setName("optQuer");
            this.optQuer.setToolTipText("DIN A4 Quer");
            this.optQuer.setText("Quer");
        }
        return this.optQuer;
    }

    private JRadioButton getOptGross() {
        if (this.optGross == null) {
            this.optGross = new JRadioButton();
            this.optGross.setName("optGross");
            this.optGross.setToolTipText("Gro\u00dfes Labyrinth");
            this.optGross.setText("Gro\u00df");
        }
        return this.optGross;
    }

    private JRadioButton getOptKlein() {
        if (this.optKlein == null) {
            this.optKlein = new JRadioButton();
            this.optKlein.setName("optKlein");
            this.optKlein.setToolTipText("Kleines Labyrinth");
            this.optKlein.setText("Klein");
        }
        return this.optKlein;
    }

    private JButton getCmdGenRnd() {
        if (this.cmdGenRnd == null) {
            this.cmdGenRnd = new JButton();
            this.cmdGenRnd.setName("cmdGenRnd");
            this.cmdGenRnd.setToolTipText("Neues Labyrinth erzeugen");
            this.cmdGenRnd.setText("Generieren");
            this.cmdGenRnd.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MainFrame.this.cmdGenRnd_actionPerformed();
                }
            });
        }
        return this.cmdGenRnd;
    }

    private LabyParam.VordefGr getVordefGr() {
        LabyParam.VordefGr ret = null;
        if (this.optHoch.isSelected() && this.optGross.isSelected()) {
            ret = LabyParam.VordefGr.GROSS_HOCH;
        }
        if (this.optHoch.isSelected() && this.optKlein.isSelected()) {
            ret = LabyParam.VordefGr.KLEIN_HOCH;
        }
        if (this.optQuer.isSelected() && this.optGross.isSelected()) {
            ret = LabyParam.VordefGr.GROSS_QUER;
        }
        if (this.optQuer.isSelected() && this.optKlein.isSelected()) {
            ret = LabyParam.VordefGr.KLEIN_QUER;
        }
        return ret;
    }

    private void cmdGenRnd_actionPerformed() {
        LabyParam p = (LabyParam)this.graph.getParams().clone();
        if (this.getVordefGr() == null) {
            p.nextSeed();
        } else if (p.getVordefGr() == this.getVordefGr()) {
            p.nextSeed();
        } else {
            p.setVordefGr(this.getVordefGr());
        }
        this.newLaby(p);
    }

    private void newLaby(LabyParam p) {
        this.enableGui(false);
        this.setCursor(Cursor.getPredefinedCursor(3));
        this.pgbProgressBar.setIndeterminate(true);
        this.pgbProgressBar.setString("Erzeuge neues Labyrinth...");
        this.genLabyTask = new GenLabyTask(p);
        this.genLabyTask.execute();
    }

    private void enableGui(boolean enable) {
        this.cmdParams.setEnabled(enable);
        this.cmdGenRnd.setEnabled(enable);
        this.cmdPrint.setEnabled(enable);
        this.optShowLsg.setEnabled(enable);
        this.optGross.setEnabled(enable);
        this.optKlein.setEnabled(enable);
        this.optHoch.setEnabled(enable);
        this.optQuer.setEnabled(enable);
    }

    private JProgressBar getPgbProgressBar() {
        if (this.pgbProgressBar == null) {
            this.pgbProgressBar = new JProgressBar();
            this.pgbProgressBar.setName("pgbProgressBar");
            this.pgbProgressBar.setString("Erzeuge neues Labyrinth...");
            this.pgbProgressBar.setStringPainted(true);
        }
        return this.pgbProgressBar;
    }

    class GenLabyTask
    extends SwingWorker<Void, Void> {
        private LabyGraph newGraph = null;
        private LabyParam param = null;

        private GenLabyTask() {
        }

        protected GenLabyTask(LabyParam param) {
            this.param = param;
        }

        @Override
        protected Void doInBackground() throws Exception {
            this.newGraph = new LabyGraph(this.param);
            return null;
        }

        @Override
        protected void done() {
            MainFrame.this.graph = this.newGraph;
            ((LabyGraphPanel)MainFrame.this.pnlMain).setGraph(this.newGraph);
            MainFrame.this.pnlMain.repaint();
            MainFrame.this.enableGui(true);
            MainFrame.this.initOptVordefGr();
            MainFrame.this.setCursor(null);
            MainFrame.this.pgbProgressBar.setIndeterminate(false);
            MainFrame.this.displayStatus(1);
        }
    }
}

