/*
 * Decompiled with CFR 0.152.
 */
package com.thorstenfischer.labyrinth.ui;

import com.thorstenfischer.labyrinth.LabyParam;
import com.thorstenfischer.ui.Util;
import com.thorstenfischer.ui.WState;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class LabyParamDlg
extends JDialog {
    private static final long serialVersionUID = 1L;
    private JPanel pnlContentPane = null;
    private JButton cmdOK = null;
    private JButton cmdAbbrechen = null;
    private JPanel pnlProps = null;
    private JSlider sldX = null;
    private JSlider sldY = null;
    private JLabel lblX = null;
    private JLabel lblY = null;
    private JPanel pnlArt = null;
    private JRadioButton cmdKariert = null;
    private JRadioButton cmdFrei = null;
    private ButtonGroup btgArt = null;
    private JSlider sldV = null;
    private JLabel lblAnzV = null;
    private JTextField txtLabyCode = null;
    private JLabel lblCode = null;
    private JLabel lblSeed = null;
    private JSpinner txtX = null;
    private JSpinner txtY = null;
    private JSpinner txtSeed = null;
    private JSpinner txtAnzV = null;
    private JPanel pnlStart = null;
    private JPanel pnlZiel = null;
    private JPanel pnlButtns = null;
    private JRadioButton cmdStartOben = null;
    private JRadioButton cmdStartMitte = null;
    private JRadioButton cmdStartUnten = null;
    private ButtonGroup btgStart = null;
    private JRadioButton cmdZielOben = null;
    private JRadioButton cmdZielMitte = null;
    private JRadioButton cmdZielUnten = null;
    private ButtonGroup btgZiel = null;
    private boolean doAction = false;
    private LabyParam params = null;
    private static final int START = 1;
    private static final int ZIEL = 2;
    private JPanel pnlSouth = null;
    private JPanel pnlStatusBar = null;
    private JLabel lblStatus = null;
    private JSlider sldSeed = null;
    private WState wState = WState.CANCEL;

    private LabyParamDlg(Frame owner) {
        super(owner);
        this.initialize();
    }

    public LabyParamDlg(Frame owner, LabyParam params) {
        this(owner);
        if (params == null) {
            throw new NullPointerException();
        }
        this.params = (LabyParam)params.clone();
        this.myInitialize();
        this.initDlg(params);
        Util.center(this);
    }

    private void initDlg(LabyParam params) {
        this.doAction = false;
        this.sldX.setValue(params.getX());
        this.sldY.setValue(params.getY());
        this.txtX.setValue(params.getX());
        this.txtY.setValue(params.getY());
        this.cmdKariert.setSelected(params.getArt() == LabyParam.Art.KARIERT);
        this.cmdFrei.setSelected(params.getArt() == LabyParam.Art.FREI);
        this.enableFreiKariert(params.getArt() == LabyParam.Art.FREI);
        this.sldV.setMaximum(params.getMaxAnzV());
        this.sldV.setMinimum(params.getMinAnzV());
        this.sldV.setValue(params.getAnzV());
        this.txtAnzV.setValue(params.getAnzV());
        this.displayLabyCode();
        this.txtSeed.setValue(params.getSeed());
        this.sldSeed.setValue((int)params.getSeed());
        this.cmdStartOben.setSelected(params.getOrtStart() == LabyParam.Ort.OBEN);
        this.cmdStartMitte.setSelected(params.getOrtStart() == LabyParam.Ort.MITTE);
        this.cmdStartUnten.setSelected(params.getOrtStart() == LabyParam.Ort.UNTEN);
        this.cmdZielOben.setSelected(params.getOrtZiel() == LabyParam.Ort.OBEN);
        this.cmdZielMitte.setSelected(params.getOrtZiel() == LabyParam.Ort.MITTE);
        this.cmdZielUnten.setSelected(params.getOrtZiel() == LabyParam.Ort.UNTEN);
        ((SpinnerNumberModel)this.txtAnzV.getModel()).setMaximum(Integer.valueOf(params.getMaxAnzV()));
        ((SpinnerNumberModel)this.txtAnzV.getModel()).setMinimum(Integer.valueOf(params.getMinAnzV()));
        this.doAction = true;
    }

    private void initialize() {
        this.setSize(556, 455);
        this.setName("LabyParamDlg");
        this.setModal(true);
        this.setPreferredSize(new Dimension(556, 455));
        this.setTitle("Einstellungen f\u00fcr ein Labyrinth");
        this.setContentPane(this.getPnlContentPane());
    }

    private void myInitialize() {
        this.btgArt = new ButtonGroup();
        this.btgArt.add(this.cmdKariert);
        this.btgArt.add(this.cmdFrei);
        this.btgStart = new ButtonGroup();
        this.btgStart.add(this.cmdStartOben);
        this.btgStart.add(this.cmdStartMitte);
        this.btgStart.add(this.cmdStartUnten);
        this.btgZiel = new ButtonGroup();
        this.btgZiel.add(this.cmdZielOben);
        this.btgZiel.add(this.cmdZielMitte);
        this.btgZiel.add(this.cmdZielUnten);
        ((SpinnerNumberModel)this.txtX.getModel()).setMaximum(Integer.valueOf(90));
        ((SpinnerNumberModel)this.txtX.getModel()).setMinimum(Integer.valueOf(10));
        ((SpinnerNumberModel)this.txtY.getModel()).setMaximum(Integer.valueOf(90));
        ((SpinnerNumberModel)this.txtY.getModel()).setMinimum(Integer.valueOf(10));
        ((SpinnerNumberModel)this.txtSeed.getModel()).setMinimum(Integer.valueOf(0));
        ((SpinnerNumberModel)this.txtSeed.getModel()).setMaximum(Integer.valueOf(9999));
    }

    private JPanel getPnlContentPane() {
        if (this.pnlContentPane == null) {
            this.pnlContentPane = new JPanel();
            this.pnlContentPane.setLayout(new BorderLayout());
            this.pnlContentPane.add((Component)this.getPnlProps(), "Center");
            this.pnlContentPane.add((Component)this.getPnlSouth(), "South");
        }
        return this.pnlContentPane;
    }

    private JButton getCmdOK() {
        if (this.cmdOK == null) {
            this.cmdOK = new JButton();
            this.cmdOK.setName("cmdOK");
            this.cmdOK.setToolTipText("Einstellungen \u00fcbernehmen und neues Labyrinth anzeigen");
            this.cmdOK.setText("OK");
            this.cmdOK.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    LabyParamDlg.this.cmdOK_actionPerformed();
                }
            });
        }
        return this.cmdOK;
    }

    private void cmdOK_actionPerformed() {
        this.wState = WState.OK;
        this.setVisible(false);
    }

    private JButton getCmdAbbrechen() {
        if (this.cmdAbbrechen == null) {
            this.cmdAbbrechen = new JButton();
            this.cmdAbbrechen.setToolTipText("Abbrechen");
            this.cmdAbbrechen.setText("Abbrechen");
            this.cmdAbbrechen.setName("cmdAbbrechen");
            this.cmdAbbrechen.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    LabyParamDlg.this.cmdAbbrechen_actionPerformed();
                }
            });
        }
        return this.cmdAbbrechen;
    }

    private void cmdAbbrechen_actionPerformed() {
        this.wState = WState.CANCEL;
        this.setVisible(false);
    }

    private JPanel getPnlProps() {
        if (this.pnlProps == null) {
            this.lblSeed = new JLabel();
            this.lblSeed.setBounds(new Rectangle(472, 14, 55, 16));
            this.lblSeed.setFont(new Font("Dialog", 0, 12));
            this.lblSeed.setText("Nummer");
            this.lblCode = new JLabel();
            this.lblCode.setBounds(new Rectangle(179, 12, 37, 25));
            this.lblCode.setText("Code");
            this.lblY = new JLabel();
            this.lblY.setBounds(new Rectangle(18, 14, 114, 16));
            this.lblY.setFont(new Font("Dialog", 0, 12));
            this.lblY.setText("Punkte auf Y-Achse");
            this.lblX = new JLabel();
            this.lblX.setText("Punkte auf X-Achse");
            this.lblX.setFont(new Font("Dialog", 0, 12));
            this.lblX.setBounds(new Rectangle(60, 292, 106, 16));
            this.lblX.setName("lblX");
            this.pnlProps = new JPanel();
            this.pnlProps.setLayout(null);
            this.pnlProps.setPreferredSize(new Dimension(550, 350));
            this.pnlProps.setMinimumSize(new Dimension(550, 350));
            this.pnlProps.setMaximumSize(new Dimension(550, 350));
            this.pnlProps.add((Component)this.getSldX(), null);
            this.pnlProps.add((Component)this.getTxtX(), null);
            this.pnlProps.add((Component)this.lblX, null);
            this.pnlProps.add((Component)this.getSldY(), null);
            this.pnlProps.add((Component)this.getTxtY(), null);
            this.pnlProps.add((Component)this.lblY, null);
            this.pnlProps.add((Component)this.getPnlArt(), null);
            this.pnlProps.add((Component)this.getTxtLabyCode(), null);
            this.pnlProps.add((Component)this.lblCode, null);
            this.pnlProps.add((Component)this.lblSeed, null);
            this.pnlProps.add((Component)this.getTxtSeed(), null);
            this.pnlProps.add((Component)this.getPnlStart(), null);
            this.pnlProps.add((Component)this.getPnlZiel(), null);
            this.pnlProps.add((Component)this.getSldSeed(), null);
        }
        return this.pnlProps;
    }

    private JSlider getSldX() {
        if (this.sldX == null) {
            this.sldX = new JSlider();
            this.sldX.setName("sldX");
            this.sldX.setMaximum(90);
            this.sldX.setMinimum(10);
            this.sldX.setValue(10);
            this.sldX.setBounds(new Rectangle(53, 273, 407, 20));
            this.sldX.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    if (LabyParamDlg.this.doAction) {
                        LabyParamDlg.this.sldX_stateChanged();
                    }
                }
            });
        }
        return this.sldX;
    }

    private void sldX_stateChanged() {
        this.doAction = false;
        int x = this.sldX.getValue();
        this.txtX.setValue(x);
        this.params.setX(x);
        this.initAnzV(this.params);
        this.displayLabyCode();
        this.doAction = true;
    }

    private JSlider getSldY() {
        if (this.sldY == null) {
            this.sldY = new JSlider();
            this.sldY.setOrientation(1);
            this.sldY.setBounds(new Rectangle(18, 28, 16, 242));
            this.sldY.setMaximum(60);
            this.sldY.setMinimum(10);
            this.sldY.setValue(10);
            this.sldY.setName("sldY");
            this.sldY.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    if (LabyParamDlg.this.doAction) {
                        LabyParamDlg.this.sldY_stateChanged();
                    }
                }
            });
        }
        return this.sldY;
    }

    private void sldY_stateChanged() {
        this.doAction = false;
        int y = this.sldY.getValue();
        this.txtY.setValue(y);
        this.params.setY(y);
        this.initAnzV(this.params);
        this.displayLabyCode();
        this.doAction = true;
    }

    private void initAnzV(LabyParam params) {
        if (params.getArt() == LabyParam.Art.KARIERT) {
            params.setAnzV(params.getMaxAnzV());
        } else {
            if (params.getAnzV() < params.getMinAnzV()) {
                params.setAnzV(params.getMinAnzV());
            }
            if (params.getAnzV() > params.getMaxAnzV()) {
                params.setAnzV(params.getMaxAnzV());
            }
        }
        this.sldV.setMaximum(params.getMaxAnzV());
        this.sldV.setMinimum(params.getMinAnzV());
        this.sldV.setValue(params.getAnzV());
        this.txtAnzV.setValue(params.getAnzV());
    }

    private JPanel getPnlArt() {
        if (this.pnlArt == null) {
            TitledBorder titledBorder = BorderFactory.createTitledBorder(null, "Art", 0, 0, new Font("Dialog", 1, 12), new Color(51, 51, 51));
            titledBorder.setBorder(null);
            this.lblAnzV = new JLabel();
            this.lblAnzV.setBounds(new Rectangle(40, 88, 111, 16));
            this.lblAnzV.setFont(new Font("Dialog", 0, 12));
            this.lblAnzV.setText("Anzahl Kreuzungen");
            this.pnlArt = new JPanel();
            this.pnlArt.setLayout(null);
            this.pnlArt.setBounds(new Rectangle(97, 47, 363, 114));
            this.pnlArt.setBorder(titledBorder);
            this.pnlArt.setVisible(true);
            this.pnlArt.add((Component)this.getCmdKariert(), null);
            this.pnlArt.add((Component)this.getCmdFrei(), null);
            this.pnlArt.add((Component)this.getSldV(), null);
            this.pnlArt.add((Component)this.lblAnzV, null);
            this.pnlArt.add((Component)this.getTxtAnzV(), null);
        }
        return this.pnlArt;
    }

    private JRadioButton getCmdKariert() {
        if (this.cmdKariert == null) {
            this.cmdKariert = new JRadioButton();
            this.cmdKariert.setBounds(new Rectangle(13, 19, 121, 21));
            this.cmdKariert.setActionCommand("");
            this.cmdKariert.setSelected(true);
            this.cmdKariert.setName("cmdKariert");
            this.cmdKariert.setText("Kariert");
            this.cmdKariert.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (LabyParamDlg.this.doAction) {
                        LabyParamDlg.this.cmdKariert_actionPerformed();
                    }
                }
            });
        }
        return this.cmdKariert;
    }

    private void cmdKariert_actionPerformed() {
        this.doAction = false;
        this.params.setArt(LabyParam.Art.KARIERT);
        this.txtAnzV.setValue(this.params.getMaxAnzV());
        this.sldV.setValue(this.params.getMaxAnzV());
        this.params.setAnzV(this.params.getMaxAnzV());
        this.displayLabyCode();
        this.enableFreiKariert(this.cmdFrei.isSelected());
        this.doAction = true;
    }

    private JRadioButton getCmdFrei() {
        if (this.cmdFrei == null) {
            this.cmdFrei = new JRadioButton();
            this.cmdFrei.setBounds(new Rectangle(13, 44, 66, 21));
            this.cmdFrei.setText("Frei");
            this.cmdFrei.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (LabyParamDlg.this.doAction) {
                        LabyParamDlg.this.cmdFrei_actionPerformed();
                    }
                }
            });
        }
        return this.cmdFrei;
    }

    private void cmdFrei_actionPerformed() {
        this.doAction = false;
        this.params.setArt(LabyParam.Art.FREI);
        this.displayLabyCode();
        this.enableFreiKariert(this.cmdFrei.isSelected());
        this.doAction = true;
    }

    private void enableFreiKariert(boolean isFreiSelected) {
        this.sldV.setEnabled(isFreiSelected);
        this.txtAnzV.setEnabled(isFreiSelected);
    }

    private JSlider getSldV() {
        if (this.sldV == null) {
            this.sldV = new JSlider();
            this.sldV.setBounds(new Rectangle(32, 70, 313, 16));
            this.sldV.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    if (LabyParamDlg.this.doAction) {
                        LabyParamDlg.this.sldV_stateChanged();
                    }
                }
            });
        }
        return this.sldV;
    }

    private void sldV_stateChanged() {
        this.doAction = false;
        int anzV = this.sldV.getValue();
        this.txtAnzV.setValue(anzV);
        this.params.setAnzV(anzV);
        this.displayLabyCode();
        this.doAction = true;
    }

    private JTextField getTxtLabyCode() {
        if (this.txtLabyCode == null) {
            this.txtLabyCode = new JTextField();
            this.txtLabyCode.setBounds(new Rectangle(221, 13, 166, 24));
            this.txtLabyCode.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    LabyParamDlg.this.txtLabyCode_actionPerformed();
                }
            });
        }
        return this.txtLabyCode;
    }

    private void txtLabyCode_actionPerformed() {
        this.doAction = false;
        String text = this.txtLabyCode.getText();
        String msg = LabyParam.isValidParamString(text);
        if (msg == null) {
            this.params = new LabyParam(text);
            this.initDlg(this.params);
        } else {
            this.txtLabyCode.setText(this.params.toString());
            this.lblStatus.setText(msg);
        }
        this.doAction = true;
    }

    private JSpinner getTxtX() {
        if (this.txtX == null) {
            this.txtX = new JSpinner();
            this.txtX.setLocation(new Point(411, 294));
            this.txtX.setSize(new Dimension(50, 20));
            this.txtX.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    if (LabyParamDlg.this.doAction) {
                        LabyParamDlg.this.txtX_stateChanged();
                    }
                }
            });
        }
        return this.txtX;
    }

    private void txtX_stateChanged() {
        this.doAction = false;
        int x = (Integer)this.txtX.getValue();
        this.sldX.setValue(x);
        this.params.setX(x);
        this.displayLabyCode();
        this.doAction = true;
    }

    private JSpinner getTxtY() {
        if (this.txtY == null) {
            this.txtY = new JSpinner();
            this.txtY.setBounds(new Rectangle(34, 36, 54, 20));
            this.txtY.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    if (LabyParamDlg.this.doAction) {
                        LabyParamDlg.this.txtY_stateChanged();
                    }
                }
            });
        }
        return this.txtY;
    }

    private void txtY_stateChanged() {
        this.doAction = false;
        int y = (Integer)this.txtY.getValue();
        this.sldY.setValue(y);
        this.params.setY(y);
        this.displayLabyCode();
        this.doAction = true;
    }

    private JSpinner getTxtSeed() {
        if (this.txtSeed == null) {
            this.txtSeed = new JSpinner();
            this.txtSeed.setLocation(new Point(472, 34));
            this.txtSeed.setSize(new Dimension(50, 20));
            this.txtSeed.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    if (LabyParamDlg.this.doAction) {
                        LabyParamDlg.this.txtSeed_stateChanged();
                    }
                }
            });
        }
        return this.txtSeed;
    }

    private void txtSeed_stateChanged() {
        this.doAction = false;
        long seed = ((Integer)this.txtSeed.getValue()).intValue();
        this.params.setSeed(seed);
        this.sldSeed.setValue((int)seed);
        this.displayLabyCode();
        this.doAction = true;
    }

    private JSpinner getTxtAnzV() {
        if (this.txtAnzV == null) {
            this.txtAnzV = new JSpinner();
            this.txtAnzV.setBounds(new Rectangle(279, 86, 61, 20));
            this.txtAnzV.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    if (LabyParamDlg.this.doAction) {
                        LabyParamDlg.this.txtAnzV_stateChanged();
                    }
                }
            });
        }
        return this.txtAnzV;
    }

    private void txtAnzV_stateChanged() {
        this.doAction = false;
        int anzV = (Integer)this.txtAnzV.getValue();
        this.sldV.setValue(anzV);
        this.params.setAnzV(anzV);
        this.displayLabyCode();
        this.doAction = true;
    }

    private JPanel getPnlStart() {
        if (this.pnlStart == null) {
            GridLayout gridLayout1 = new GridLayout();
            gridLayout1.setRows(3);
            this.pnlStart = new JPanel();
            this.pnlStart.setLayout(gridLayout1);
            this.pnlStart.setBorder(BorderFactory.createTitledBorder(null, "Start", 0, 0, new Font("Dialog", 1, 12), new Color(51, 51, 51)));
            this.pnlStart.setSize(new Dimension(171, 88));
            this.pnlStart.setLocation(new Point(97, 174));
            this.pnlStart.add((Component)this.getCmdStartOben(), null);
            this.pnlStart.add((Component)this.getCmdStartMitte(), null);
            this.pnlStart.add((Component)this.getCmdStartUnten(), null);
        }
        return this.pnlStart;
    }

    private JPanel getPnlZiel() {
        if (this.pnlZiel == null) {
            GridLayout gridLayout = new GridLayout();
            gridLayout.setRows(3);
            this.pnlZiel = new JPanel();
            this.pnlZiel.setLayout(gridLayout);
            this.pnlZiel.setBounds(new Rectangle(288, 174, 171, 88));
            this.pnlZiel.setBorder(BorderFactory.createTitledBorder(null, "Ziel", 0, 0, new Font("Dialog", 1, 12), new Color(51, 51, 51)));
            this.pnlZiel.add((Component)this.getCmdZielOben(), null);
            this.pnlZiel.add((Component)this.getCmdZielMitte(), null);
            this.pnlZiel.add((Component)this.getCmdZielUnten(), null);
        }
        return this.pnlZiel;
    }

    private JPanel getPnlButtns() {
        if (this.pnlButtns == null) {
            this.pnlButtns = new JPanel();
            this.pnlButtns.setLayout(new FlowLayout());
            this.pnlButtns.setName("pnlButtons");
            this.pnlButtns.add((Component)this.getCmdOK(), null);
            this.pnlButtns.add((Component)this.getCmdAbbrechen(), null);
        }
        return this.pnlButtns;
    }

    private JRadioButton getCmdStartOben() {
        if (this.cmdStartOben == null) {
            this.cmdStartOben = new JRadioButton();
            this.cmdStartOben.setText("Oben");
            this.cmdStartOben.setName("cmdStartOben");
            this.cmdStartOben.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (LabyParamDlg.this.doAction) {
                        LabyParamDlg.this.cmdStartZielOrt_actionPerformed(1, LabyParam.Ort.OBEN);
                    }
                }
            });
        }
        return this.cmdStartOben;
    }

    private void cmdStartZielOrt_actionPerformed(int startZiel, LabyParam.Ort ort) {
        this.doAction = false;
        if (startZiel == 1) {
            this.params.setOrtStart(ort);
        } else {
            this.params.setOrtZiel(ort);
        }
        this.displayLabyCode();
        this.doAction = true;
    }

    private JRadioButton getCmdStartMitte() {
        if (this.cmdStartMitte == null) {
            this.cmdStartMitte = new JRadioButton();
            this.cmdStartMitte.setText("Mitte");
            this.cmdStartMitte.setName("cmdStartMitte");
            this.cmdStartMitte.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (LabyParamDlg.this.doAction) {
                        LabyParamDlg.this.cmdStartZielOrt_actionPerformed(1, LabyParam.Ort.MITTE);
                    }
                }
            });
        }
        return this.cmdStartMitte;
    }

    private JRadioButton getCmdStartUnten() {
        if (this.cmdStartUnten == null) {
            this.cmdStartUnten = new JRadioButton();
            this.cmdStartUnten.setText("Unten");
            this.cmdStartUnten.setName("cmdStartUnten");
            this.cmdStartUnten.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (LabyParamDlg.this.doAction) {
                        LabyParamDlg.this.cmdStartZielOrt_actionPerformed(1, LabyParam.Ort.UNTEN);
                    }
                }
            });
        }
        return this.cmdStartUnten;
    }

    private JRadioButton getCmdZielOben() {
        if (this.cmdZielOben == null) {
            this.cmdZielOben = new JRadioButton();
            this.cmdZielOben.setName("cmdZielOben");
            this.cmdZielOben.setText("Oben");
            this.cmdZielOben.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (LabyParamDlg.this.doAction) {
                        LabyParamDlg.this.cmdStartZielOrt_actionPerformed(2, LabyParam.Ort.OBEN);
                    }
                }
            });
        }
        return this.cmdZielOben;
    }

    private JRadioButton getCmdZielMitte() {
        if (this.cmdZielMitte == null) {
            this.cmdZielMitte = new JRadioButton();
            this.cmdZielMitte.setName("cmdZielMitte");
            this.cmdZielMitte.setText("Mitte");
            this.cmdZielMitte.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (LabyParamDlg.this.doAction) {
                        LabyParamDlg.this.cmdStartZielOrt_actionPerformed(2, LabyParam.Ort.MITTE);
                    }
                }
            });
        }
        return this.cmdZielMitte;
    }

    private JRadioButton getCmdZielUnten() {
        if (this.cmdZielUnten == null) {
            this.cmdZielUnten = new JRadioButton();
            this.cmdZielUnten.setName("cmdZielUnten");
            this.cmdZielUnten.setText("Unten");
            this.cmdZielUnten.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (LabyParamDlg.this.doAction) {
                        LabyParamDlg.this.cmdStartZielOrt_actionPerformed(2, LabyParam.Ort.UNTEN);
                    }
                }
            });
        }
        return this.cmdZielUnten;
    }

    private void displayLabyCode() {
        this.txtLabyCode.setText(this.params.toString());
        this.lblStatus.setText(" ");
    }

    private JPanel getPnlSouth() {
        if (this.pnlSouth == null) {
            this.pnlSouth = new JPanel();
            this.pnlSouth.setLayout(new BorderLayout());
            this.pnlSouth.setName("pnlSouth");
            this.pnlSouth.add((Component)this.getPnlButtns(), "North");
            this.pnlSouth.add((Component)this.getPnlStatusBar(), "South");
        }
        return this.pnlSouth;
    }

    private JPanel getPnlStatusBar() {
        if (this.pnlStatusBar == null) {
            FlowLayout flowLayout = new FlowLayout();
            flowLayout.setAlignment(0);
            this.lblStatus = new JLabel();
            this.lblStatus.setText(" ");
            this.lblStatus.setFont(new Font("Dialog", 0, 12));
            this.lblStatus.setName("lblStatus");
            this.lblStatus.setHorizontalAlignment(2);
            this.pnlStatusBar = new JPanel();
            this.pnlStatusBar.setBorder(BorderFactory.createBevelBorder(1));
            this.pnlStatusBar.setLayout(flowLayout);
            this.pnlStatusBar.setName("pnlStatusBar");
            this.pnlStatusBar.add((Component)this.lblStatus, null);
        }
        return this.pnlStatusBar;
    }

    private JSlider getSldSeed() {
        if (this.sldSeed == null) {
            this.sldSeed = new JSlider();
            this.sldSeed.setBounds(new Rectangle(524, 30, 21, 245));
            this.sldSeed.setOrientation(1);
            this.sldSeed.setComponentOrientation(ComponentOrientation.RIGHT_TO_LEFT);
            this.sldSeed.setName("sldSeed");
            this.sldSeed.setMaximum(9999);
            this.sldSeed.setMinimum(0);
            this.sldSeed.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    if (LabyParamDlg.this.doAction) {
                        LabyParamDlg.this.sldSeed_stateChanged();
                    }
                }
            });
        }
        return this.sldSeed;
    }

    private void sldSeed_stateChanged() {
        this.doAction = false;
        int seed = this.sldSeed.getValue();
        this.txtSeed.setValue(seed);
        this.params.setSeed(seed);
        this.displayLabyCode();
        this.doAction = true;
    }

    public WState getWState() {
        return this.wState;
    }

    public LabyParam getParams() {
        return this.params;
    }
}

