/*
 * Decompiled with CFR 0.152.
 */
package com.thorstenfischer.labyrinth.ui;

import com.thorstenfischer.labyrinth.LabyGraph;
import com.thorstenfischer.labyrinth.LabyParam;
import com.thorstenfischer.ui.GraphPanel;
import com.thorstenfischer.ui.Util;
import com.thorstenfischer.util.Edge;
import com.thorstenfischer.util.Vertex;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.image.BufferedImage;
import javax.sound.sampled.Clip;
import javax.swing.AbstractAction;
import javax.swing.KeyStroke;

public class LabyGraphPanel
extends GraphPanel {
    private static final long serialVersionUID = 1L;
    private static final double STEP = 1.0;
    private boolean showLsg = false;
    private BufferedImage startImg = null;
    private BufferedImage zielImg = null;
    private double hX;
    private double hY;
    private LabyGraph lGraph = null;
    private Clip boing = null;
    private Clip jubel = null;

    public LabyGraphPanel(LabyGraph graph) {
        super(graph);
        this.setGraph(graph);
        this.loadRessources();
        this.keyBind();
    }

    private void keyBind() {
        this.getInputMap(2).put(KeyStroke.getKeyStroke("RIGHT"), "rechts");
        this.getActionMap().put("rechts", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LabyGraphPanel.this.haseHuepf(Richtung.RECHTS);
            }
        });
        this.getInputMap(2).put(KeyStroke.getKeyStroke("LEFT"), "links");
        this.getActionMap().put("links", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LabyGraphPanel.this.haseHuepf(Richtung.LINKS);
            }
        });
        this.getInputMap(2).put(KeyStroke.getKeyStroke("UP"), "rauf");
        this.getActionMap().put("rauf", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LabyGraphPanel.this.haseHuepf(Richtung.RAUF);
            }
        });
        this.getInputMap(2).put(KeyStroke.getKeyStroke("DOWN"), "runter");
        this.getActionMap().put("runter", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LabyGraphPanel.this.haseHuepf(Richtung.RUNTER);
            }
        });
        this.getInputMap(2).put(KeyStroke.getKeyStroke("ESCAPE"), "esc");
        this.getActionMap().put("esc", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LabyGraphPanel.this.haseHuepf(Richtung.ANFANG);
            }
        });
    }

    private void haseHuepf(Richtung r) {
        double nX = this.hX;
        double nY = this.hY;
        boolean canMove = true;
        if (this.lGraph.getArt() != LabyParam.Art.KARIERT) {
            return;
        }
        switch (r) {
            case ANFANG: {
                this.initHase();
                nX = this.hX;
                nY = this.hY;
                break;
            }
            case LINKS: {
                nX = this.hX - 1.0;
                nY = this.hY;
                if (this.lGraph.existsEdge(this.hX, this.hY, nX, nY) && !com.thorstenfischer.util.Util.isLesser(nX, this.getMinX())) break;
                canMove = false;
                break;
            }
            case RECHTS: {
                nX = this.hX + 1.0;
                nY = this.hY;
                if (this.lGraph.existsEdge(this.hX, this.hY, nX, nY) && !com.thorstenfischer.util.Util.isLesser(this.getMaxX(), nX)) break;
                canMove = false;
                break;
            }
            case RAUF: {
                nX = this.hX;
                nY = this.hY + 1.0;
                if (this.lGraph.existsEdge(this.hX, this.hY, nX, nY) && !com.thorstenfischer.util.Util.isLesser(this.getMaxY(), this.hY)) break;
                canMove = false;
                break;
            }
            case RUNTER: {
                nX = this.hX;
                nY = this.hY - 1.0;
                if (this.lGraph.existsEdge(this.hX, this.hY, nX, nY) && !com.thorstenfischer.util.Util.isLesser(this.hY, this.getMinY())) break;
                canMove = false;
            }
        }
        if (canMove) {
            this.hX = nX;
            this.hY = nY;
            Vertex zielV = this.lGraph.getZiel();
            double ziX = zielV.getX();
            double ziY = zielV.getY();
            if (com.thorstenfischer.util.Util.isEqual(this.hX, ziX) && com.thorstenfischer.util.Util.isEqual(this.hY, ziY)) {
                this.jubel.setFramePosition(0);
                this.jubel.start();
            }
            if (r != Richtung.ANFANG) {
                this.repaint(this.scX(this.hX - 0.5 - 1.0) + 2, this.scY(this.hY + 0.5 + 1.0) + 2, 3 * this.scWX(1.0), 3 * this.scWY(1.0));
            } else {
                this.repaint();
            }
        } else {
            this.boing.setFramePosition(0);
            this.boing.start();
        }
    }

    private void loadRessources() {
        Toolkit dTk = Toolkit.getDefaultToolkit();
        this.startImg = Util.toBufferedImage(dTk.getImage(this.getClass().getResource("/com/thorstenfischer/labyrinth/ui/Hase.gif")));
        this.zielImg = Util.toBufferedImage(dTk.getImage(this.getClass().getResource("/com/thorstenfischer/labyrinth/ui/Moehre.gif")));
        this.boing = Util.loadClip(this.getClass().getResource("/com/thorstenfischer/labyrinth/ui/boing.wav"));
        this.jubel = Util.loadClip(this.getClass().getResource("/com/thorstenfischer/labyrinth/ui/jubel.wav"));
    }

    public void setGraph(LabyGraph graph) {
        this.lGraph = graph;
        this.setMinX(graph.getMinX() - 0.5);
        this.setMinY(graph.getMinY() - 0.5);
        this.setMaxX(graph.getMaxX() + 0.5);
        this.setMaxY(graph.getMaxY() + 0.5);
        this.initHase();
    }

    private void initHase() {
        Vertex startV = this.lGraph.getStart();
        this.hX = startV.getX();
        this.hY = startV.getY();
    }

    private int scWY(double y) {
        return Math.abs(this.scY(1.5) - this.scY(0.5));
    }

    private int scWX(double x) {
        return Math.abs(this.scX(1.5) - this.scX(0.5));
    }

    private void paintFrei(Graphics2D g) {
        g.setColor(Color.BLACK);
        for (Vertex v : this.lGraph.getVS()) {
            int vx = this.scX(v.getX()) - v.getThick();
            int vy = this.scY(v.getY()) - v.getThick();
            g.fillOval(vx, vy, v.getThick() * 2, v.getThick() * 2);
        }
        for (Edge e : this.lGraph.getES()) {
            this.dL(g, e.getV1().getX(), e.getV1().getY(), e.getV2().getX(), e.getV2().getY());
        }
    }

    private void paintLsg(Graphics2D g) {
        if (this.showLsg) {
            for (Edge e : this.lGraph.getLsg()) {
                g.setColor(e.getColor());
                this.dL(g, e.getV1().getX(), e.getV1().getY(), e.getV2().getX(), e.getV2().getY());
            }
        }
    }

    private void paintHase(Graphics2D g) {
        g.drawImage(this.startImg, this.scX(this.hX - 0.5) + 2, this.scY(this.hY + 0.5) + 2, this.scWX(1.0) - 4, this.scWY(1.0) - 4, null);
    }

    private void paintZiel(Graphics2D g) {
        Vertex zielV = this.lGraph.getZiel();
        double ziX = zielV.getX();
        double ziY = zielV.getY();
        g.drawImage(this.zielImg, this.scX(ziX - 0.5) + 2, this.scY(ziY + 0.5) + 2, this.scWX(1.0) - 4, this.scWY(1.0) - 4, null);
    }

    private void paintKariert(Graphics2D g) {
        double minX = this.lGraph.getMinX();
        double maxX = this.lGraph.getMaxX();
        double minY = this.lGraph.getMinY();
        double maxY = this.lGraph.getMaxY();
        double stepH = 0.5;
        g.setColor(Color.BLACK);
        double x = minX;
        while (x <= maxX) {
            double y = minY;
            while (y <= maxY) {
                if (!this.lGraph.existsEdge(x, y, x, y + 1.0)) {
                    this.dL(g, x - stepH, y + stepH, x + stepH, y + stepH);
                }
                if (!this.lGraph.existsEdge(x, y, x + 1.0, y)) {
                    this.dL(g, x + stepH, y + stepH, x + stepH, y - stepH);
                }
                if (!this.lGraph.existsEdge(x, y, x, y - 1.0)) {
                    this.dL(g, x - stepH, y - stepH, x + stepH, y - stepH);
                }
                if (!this.lGraph.existsEdge(x, y, x - 1.0, y)) {
                    this.dL(g, x - stepH, y - stepH, x - stepH, y + stepH);
                }
                y += 1.0;
            }
            x += 1.0;
        }
    }

    @Override
    public void paint(Graphics g) {
        this.setDoPainting(false);
        super.paint(g);
        this.setDoPainting(true);
        Graphics2D g2d = (Graphics2D)g;
        if (this.lGraph.getArt() == LabyParam.Art.FREI) {
            this.paintFrei(g2d);
        } else {
            this.paintKariert(g2d);
        }
        this.paintLsg(g2d);
        this.paintZiel(g2d);
        this.paintHase(g2d);
        if (this.isPrinting()) {
            this.paintHeaderFooter(g2d);
        }
    }

    private void paintHeaderFooter(Graphics2D g2d) {
        FontMetrics fontMetrics = g2d.getFontMetrics();
        int fHeight = fontMetrics.getHeight();
        String s = "www.ThorstenFischer.com/labyrinth";
        int fWidth = fontMetrics.stringWidth(s);
        g2d.drawString(s, this.scX(this.getMaxX()) - fWidth, this.scY(0.5) + fHeight);
        g2d.drawString(String.valueOf(this.lGraph.getParams().toString()) + (this.lGraph.isBadLsg() ? "-" : "+"), this.scX(0.5), this.scY(0.5) + fHeight);
    }

    public void setShowLsg(boolean showLsg) {
        this.showLsg = showLsg;
    }

    private static enum Richtung {
        RAUF,
        LINKS,
        RUNTER,
        RECHTS,
        ANFANG;

    }
}

