/*
 * Decompiled with CFR 0.152.
 */
package com.thorstenfischer.labyrinth;

import java.awt.Color;

public class LabyParam
implements Cloneable {
    public static final Color LSG_COLOR = Color.GREEN;
    private int x = 10;
    public static final int MIN_X = 10;
    public static final int MAX_X = 90;
    private int y = 10;
    public static final int MIN_Y = 10;
    public static final int MAX_Y = 60;
    public static final int X_GROSS_HOCH = 20;
    public static final int X_KLEIN_HOCH = 10;
    public static final int X_GROSS_QUER = 28;
    public static final int X_KLEIN_QUER = 14;
    public static final int Y_GROSS_HOCH = 28;
    public static final int Y_KLEIN_HOCH = 14;
    public static final int Y_GROSS_QUER = 20;
    public static final int Y_KLEIN_QUER = 10;
    private long seed = 0L;
    public static final int MIN_SEED = 0;
    public static final int MAX_SEED = 9999;
    private Art art = Art.KARIERT;
    private int anzV = 100;
    private Ort ortStart = Ort.OBEN;
    private Ort ortZiel = Ort.UNTEN;

    public int getAnzV() {
        return this.anzV;
    }

    public void setAnzV(int anzV) {
        this.anzV = anzV;
    }

    public Art getArt() {
        return this.art;
    }

    public void setArt(Art art) {
        this.art = art;
    }

    public long getSeed() {
        return this.seed;
    }

    public void setSeed(long seed) {
        if (seed < 0L || seed > 9999L) {
            return;
        }
        this.seed = seed;
    }

    public int getX() {
        return this.x;
    }

    public void setX(int x) {
        if (x < 10 || x > 90) {
            return;
        }
        this.x = x;
        if (this.getAnzV() > this.getMaxAnzV()) {
            this.setAnzV(this.getMaxAnzV());
        }
        if (this.getAnzV() < this.getMinAnzV()) {
            this.setAnzV(this.getMinAnzV());
        }
    }

    public int getY() {
        return this.y;
    }

    public void setY(int y) {
        if (y < 10 || y > 60) {
            return;
        }
        this.y = y;
        if (this.getAnzV() > this.getMaxAnzV()) {
            this.setAnzV(this.getMaxAnzV());
        }
        if (this.getAnzV() < this.getMinAnzV()) {
            this.setAnzV(this.getMinAnzV());
        }
    }

    public int getMinAnzV() {
        return (int)((double)this.getMaxAnzV() * 0.5);
    }

    public int getMaxAnzV() {
        return this.x * this.y;
    }

    public Ort getOrtStart() {
        return this.ortStart;
    }

    public void setOrtStart(Ort ortStart) {
        this.ortStart = ortStart;
    }

    public Ort getOrtZiel() {
        return this.ortZiel;
    }

    public void setOrtZiel(Ort ortZiel) {
        this.ortZiel = ortZiel;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cnse) {
            cnse.printStackTrace(System.err);
            System.exit(1);
            return null;
        }
    }

    public String toString() {
        String s = String.valueOf(this.art == Art.KARIERT ? "K" : "F") + String.format("%03d%03d%06d", this.x, this.y, this.anzV) + (this.ortStart == Ort.OBEN ? "O" : (this.ortStart == Ort.MITTE ? "M" : "U")) + (this.ortZiel == Ort.OBEN ? "O" : (this.ortZiel == Ort.MITTE ? "M" : "U")) + String.format("%04d", this.seed);
        return s;
    }

    public LabyParam() {
    }

    public LabyParam(String params) throws NumberFormatException {
        this.parseParams(params);
    }

    public void parseParams(String params) throws NumberFormatException {
        if (params == null || params.length() == 0) {
            throw new NumberFormatException();
        }
        Art artS = this.art;
        int xS = this.x;
        int yS = this.y;
        int anzVS = this.anzV;
        Ort ortStartS = this.ortStart;
        Ort ortZielS = this.ortZiel;
        long seedS = this.seed;
        try {
            String a = params.substring(0, 1);
            if (a.equals("K")) {
                this.art = Art.KARIERT;
            } else if (a.equals("F")) {
                this.art = Art.FREI;
            } else {
                throw new NumberFormatException("Art nur K oder F");
            }
            this.x = Integer.parseInt(params.substring(1, 4));
            if (this.x < 10 || this.x > 90) {
                throw new NumberFormatException("X nur zwischen 10 und 90");
            }
            this.y = Integer.parseInt(params.substring(4, 7));
            if (this.y < 10 || this.y > 60) {
                throw new NumberFormatException("Y nur zwischen 10 und 60");
            }
            this.anzV = Integer.parseInt(params.substring(7, 13));
            if (this.art == Art.FREI && this.anzV < this.getMinAnzV() || this.anzV > this.getMaxAnzV()) {
                throw new NumberFormatException("Anzahl der Knoten nur zwischen " + this.getMinAnzV() + " und " + this.getMaxAnzV());
            }
            if (this.art == Art.KARIERT && this.anzV != this.x * this.y) {
                throw new NumberFormatException("Anzahl der Knoten mu\u00df " + this.x * this.y + " sein");
            }
            a = params.substring(13, 14);
            if (a.equals("O")) {
                this.ortStart = Ort.OBEN;
            } else if (a.equals("M")) {
                this.ortStart = Ort.MITTE;
            } else if (a.equals("U")) {
                this.ortStart = Ort.UNTEN;
            } else {
                throw new NumberFormatException("Startort nur O, M oder U");
            }
            a = params.substring(14, 15);
            if (a.equals("O")) {
                this.ortZiel = Ort.OBEN;
            } else if (a.equals("M")) {
                this.ortZiel = Ort.MITTE;
            } else if (a.equals("U")) {
                this.ortZiel = Ort.UNTEN;
            } else {
                throw new NumberFormatException("Zielort nur O, M oder U");
            }
            this.seed = Integer.parseInt(params.substring(15, 19));
            if (this.seed < 0L || this.seed > 9999L) {
                throw new NumberFormatException("Nummer nur zwischen 0 und 9999");
            }
        }
        catch (NumberFormatException nfe) {
            this.art = artS;
            this.x = xS;
            this.y = yS;
            this.anzV = anzVS;
            this.ortStart = ortStartS;
            this.ortZiel = ortZielS;
            this.seed = seedS;
            throw new NumberFormatException(nfe.getMessage());
        }
    }

    public static String isValidParamString(String params) {
        String ret = null;
        try {
            LabyParam test = new LabyParam(params);
            if (test == null) {
                test = null;
            }
        }
        catch (NumberFormatException nfe) {
            ret = nfe.getMessage();
        }
        return ret;
    }

    public Groesse getGroesse() {
        Groesse ret = null;
        if (this.x == 28 && this.y == 20 || this.x == 20 && this.y == 28) {
            ret = Groesse.GROSS;
        }
        if (this.x == 14 && this.y == 10 || this.x == 10 && this.y == 14) {
            ret = Groesse.KLEIN;
        }
        return ret;
    }

    public Ausrichtung getAusrichtung() {
        Ausrichtung ret = null;
        if (this.x == 28 && this.y == 20 || this.x == 14 && this.y == 10) {
            ret = Ausrichtung.QUER;
        }
        if (this.x == 20 && this.y == 28 || this.x == 10 && this.y == 14) {
            ret = Ausrichtung.HOCH;
        }
        return ret;
    }

    public VordefGr getVordefGr() {
        VordefGr ret = null;
        if (this.getAusrichtung() == Ausrichtung.QUER && this.getGroesse() == Groesse.GROSS) {
            ret = VordefGr.GROSS_QUER;
        }
        if (this.getAusrichtung() == Ausrichtung.HOCH && this.getGroesse() == Groesse.GROSS) {
            ret = VordefGr.GROSS_HOCH;
        }
        if (this.getAusrichtung() == Ausrichtung.QUER && this.getGroesse() == Groesse.KLEIN) {
            ret = VordefGr.KLEIN_QUER;
        }
        if (this.getAusrichtung() == Ausrichtung.HOCH && this.getGroesse() == Groesse.KLEIN) {
            ret = VordefGr.KLEIN_HOCH;
        }
        return ret;
    }

    public void nextSeed() {
        ++this.seed;
        if (this.seed > 9999L) {
            this.seed = 0L;
        }
    }

    public void setVordefGr(VordefGr vordefGr) {
        if (vordefGr == VordefGr.GROSS_HOCH) {
            this.setX(20);
            this.setY(28);
        } else if (vordefGr == VordefGr.GROSS_QUER) {
            this.setX(28);
            this.setY(20);
        } else if (vordefGr == VordefGr.KLEIN_HOCH) {
            this.setX(10);
            this.setY(14);
        } else if (vordefGr == VordefGr.KLEIN_QUER) {
            this.setX(14);
            this.setY(10);
        }
    }

    public static enum Art {
        KARIERT,
        FREI;

    }

    public static enum Ort {
        OBEN,
        MITTE,
        UNTEN;

    }

    public static enum Groesse {
        GROSS,
        KLEIN;

    }

    public static enum Ausrichtung {
        HOCH,
        QUER;

    }

    public static enum VordefGr {
        GROSS_HOCH,
        KLEIN_HOCH,
        GROSS_QUER,
        KLEIN_QUER;

    }
}

