/*
 * Decompiled with CFR 0.152.
 */
package com.thorstenfischer.labyrinth;

import com.thorstenfischer.labyrinth.LabyParam;
import com.thorstenfischer.util.Edge;
import com.thorstenfischer.util.Graph;
import com.thorstenfischer.util.Util;
import com.thorstenfischer.util.Vertex;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;

public class LabyGraph
extends Graph {
    Vertex start = null;
    Vertex ziel = null;
    List<Edge> lsg = null;
    private Random rnd = new Random();
    private LabyParam params = new LabyParam();
    public static final long LSG_VERSUCH_ZEIT_MS = 10000L;
    public static final int RND_EDGE_BY_MARKED = -1;
    public static final int RND_EDGE_BY_MIN_ADJ = -2;
    public static final int RND_EDGE_BY_MIN_ADJ_MARKED = -3;
    public boolean debug = false;

    public LabyGraph() {
    }

    public LabyGraph(LabyParam params) {
        this.params = params;
        this.rnd = new Random(params.getSeed());
        this.createRohGraph();
        this.createLaby();
        this.setLsgColor(LabyParam.LSG_COLOR);
    }

    public Vertex getStart() {
        return this.start;
    }

    private void setStart(Vertex start) {
        this.start = start;
    }

    public Vertex getZiel() {
        return this.ziel;
    }

    private void setZiel(Vertex ziel) {
        this.ziel = ziel;
    }

    public LabyParam getParams() {
        return this.params;
    }

    public void setLsgColor(Color color) {
        if (this.lsg == null) {
            return;
        }
        if (this.lsg.size() == 0) {
            return;
        }
        for (Edge iE : this.lsg) {
            iE.setColor(color);
        }
    }

    private Edge getRandomAdjEdge(Vertex v, boolean markedE, boolean markedV, int countE) {
        if (this.debug) {
            System.out.println("--- v = " + v);
        }
        if (countE < 0 && countE != -2 && countE != -1 && countE != -3) {
            throw new IllegalArgumentException();
        }
        Edge found = null;
        Set<Edge> adjE = this.getAdjEdges(v);
        if (adjE == null) {
            return null;
        }
        if (adjE.size() == 0) {
            return null;
        }
        ArrayList<Edge> founds = new ArrayList<Edge>();
        for (Edge iE : adjE) {
            int cntMinV;
            int cntEdges;
            if (this.debug) {
                System.out.println("AdEdge: " + iE);
            }
            if (countE == -1) {
                if (iE.isMarked() != markedE || iE.getDestVertex(v).isMarked() != markedV) continue;
                founds.add(iE);
                continue;
            }
            if (countE == -2) {
                cntEdges = this.getCountEdges(iE.getDestVertex(v), !markedE);
                cntMinV = this.getCountMinV(v, !markedE);
                if (iE.isMarked() != markedE || cntEdges != cntMinV) continue;
                founds.add(iE);
                continue;
            }
            if (countE == -3) {
                cntEdges = this.getCountEdges(iE.getDestVertex(v), !markedE);
                if (this.debug) {
                    System.out.println("cntEdges:" + cntEdges);
                }
                cntMinV = this.getCountMinMarkedV(v, markedV, !markedE);
                if (this.debug) {
                    System.out.println("cntMinV:" + cntMinV);
                }
                if (iE.isMarked() != markedE || iE.getDestVertex(v).isMarked() != markedV || cntEdges != cntMinV) continue;
                founds.add(iE);
                if (!this.debug) continue;
                System.out.println("hinzugef\u00fcgt");
                continue;
            }
            if (countE < 0 || iE.isMarked() != markedE || iE.getDestVertex(v).isMarked() != markedV || this.getCountEdges(iE.getDestVertex(v), !markedE) != countE) continue;
            if (this.debug) {
                System.out.println("iE.isMarked()" + iE.isMarked());
                System.out.println("iE.getDestVertex(v).isMarked()" + iE.getDestVertex(v).isMarked());
                System.out.println("getCountEdges(iE.getDestVertex(v), markedE)" + this.getCountEdges(iE.getDestVertex(v), markedE));
            }
            founds.add(iE);
        }
        found = (Edge)Util.getRandomElem(founds, this.rnd);
        return found;
    }

    private boolean initLsg() {
        if (this.start == null || this.ziel == null) {
            throw new NullPointerException();
        }
        if (!this.contains(this.start) || !this.contains(this.ziel)) {
            throw new IllegalArgumentException("Start oder Ziel nicht enthalten.");
        }
        this.lsg = new ArrayList<Edge>();
        Vertex aktV = this.start;
        Edge aktE = null;
        Edge e = null;
        boolean done = false;
        int i = -1;
        this.unmarkAll();
        if (this.debug) {
            System.out.println("Start bei: " + aktV);
        }
        aktV.setMarked(true);
        do {
            e = this.getRandomAdjEdge(aktV, false, false, -1);
            if (this.debug) {
                System.out.println("Versuche Kante: " + e);
            }
            if (e != null) {
                e.setMarked(true);
                this.lsg.add(e);
                ++i;
                aktV = e.getDestVertex(aktV);
                aktV.setMarked(true);
                aktE = e;
                done = aktV.equals(this.ziel);
                continue;
            }
            boolean bl = done = aktV.equals(this.start) && this.getCountVertex() == this.getCountVertex(true);
            if (!done) {
                aktV = aktE.getSrcVertex(aktV);
                aktV.setMarked(true);
                if (this.debug) {
                    System.out.println("Noch nicht wieder am Start. Zur\u00fcck \u00fcber " + aktE + " nach " + aktV);
                }
                if (this.debug) {
                    System.out.println("aktueller lsg-Weg:");
                }
                if (this.debug) {
                    int j = 0;
                    while (j < this.lsg.size()) {
                        Edge tmp = this.lsg.get(j);
                        System.out.println(String.valueOf(j) + ":" + tmp);
                        ++j;
                    }
                }
                if (this.debug) {
                    System.out.println("removed: " + i + " " + this.lsg.get(i));
                }
                this.lsg.remove(i);
                aktE = this.lsg.size() != 0 ? this.lsg.get(--i) : null;
                if (!this.debug) continue;
                System.out.println("aktE = " + aktE);
                continue;
            }
            this.lsg = null;
        } while (!done);
        if (this.lsg == null) {
            return false;
        }
        if (this.lsg.size() == 0) {
            this.lsg = null;
            return false;
        }
        return true;
    }

    private void delAdjStartZiel() {
        this.deleteAdjEdges(this.start, false);
        this.deleteAdjEdges(this.ziel, false);
    }

    private void markLsgWegElems() {
        if (this.lsg == null) {
            return;
        }
        if (this.lsg.size() == 0) {
            return;
        }
        for (Edge e : this.lsg) {
            e.setMarked(true);
            e.getV1().setMarked(true);
            e.getV2().setMarked(true);
        }
    }

    private void initLsgSackgassen() {
        if (this.lsg == null || this.start == null || this.ziel == null) {
            throw new NullPointerException();
        }
        if (this.lsg.size() == 0) {
            throw new IllegalStateException("Lsg.-weg ist leer.");
        }
        if (this.lsg.size() == 1) {
            return;
        }
        ArrayList<Vertex> rwV = new ArrayList<Vertex>();
        int i = 0;
        Vertex aktV = this.start;
        Edge aktE = this.lsg.get(i);
        Vertex nextV = null;
        Edge nextE = null;
        boolean done = false;
        do {
            nextV = aktE.getDestVertex(aktV);
            if (i + 1 < this.lsg.size()) {
                nextE = this.lsg.get(i + 1);
                if (!(Double.isNaN(aktE.getA()) && Double.isNaN(nextE.getA()) || Util.isEqual(aktE.getA(), nextE.getA()) || this.rnd.nextInt(2) != 1)) {
                    rwV.add(nextV);
                }
                aktE = nextE;
                aktV = nextV;
                ++i;
                continue;
            }
            done = true;
        } while (!done);
        for (Vertex iV : rwV) {
            iV.setColor(Color.RED);
        }
        for (Vertex iV : rwV) {
            aktV = iV;
            aktE = this.getRandomAdjEdge(aktV, false, false, 0);
            done = aktE == null;
            while (!done) {
                aktE.setMarked(true);
                aktE.setColor(Color.BLACK);
                aktV = aktE.getDestVertex(aktV);
                aktV.setMarked(true);
                aktV.setColor(Color.BLACK);
                aktE = this.getRandomAdjEdge(aktV, false, false, 0);
                boolean bl = done = aktE == null;
            }
        }
    }

    private void initUnverbVertex() {
        List<Vertex> uV = this.getVertex(false);
        while (uV != null) {
            ArrayList<Vertex> bV = new ArrayList<Vertex>();
            for (Vertex iV : uV) {
                if (this.getCountVertex(iV, true) <= 0) continue;
                bV.add(iV);
            }
            if (bV.size() == 0) {
                throw new IllegalStateException("Kein unbesuchter Knoten, der nicht benachbart w\u00e4re.");
            }
            Vertex s = (Vertex)Util.getRandomElem(bV, this.rnd);
            if (this.debug) {
                System.out.println("Startknoten: " + s);
            }
            Edge verbE = this.getRandomAdjEdge(s, false, true, -3);
            if (this.debug) {
                System.out.println("VerbE: " + verbE);
            }
            verbE.setMarked(true);
            verbE.setColor(Color.BLUE);
            s.setMarked(true);
            s.setColor(Color.BLUE);
            uV = this.getVertex(false);
        }
    }

    public boolean isBadLsg() {
        if (this.lsg == null) {
            return true;
        }
        double markedRatio = (double)this.lsg.size() / (double)this.getCountVertex();
        return markedRatio < 0.2 || markedRatio > 0.3;
    }

    private void createRohGraph() {
        if (this.params == null) {
            throw new IllegalStateException();
        }
        if (this.params.getArt() == LabyParam.Art.FREI) {
            this.setVertexRandom(this.rnd, 1, 1, this.params.getX(), this.params.getY(), this.params.getAnzV());
            this.setEdgesAll(false);
        } else {
            this.setVertexChecked(this.params.getX(), this.params.getY());
            this.setEdgesAll(true);
        }
        SortedSet<Vertex> startSpalte = this.getVertexByColumn(this.getMinX());
        SortedSet<Vertex> zielSpalte = this.getVertexByColumn(this.getMaxX());
        this.setStart(this.getElem(startSpalte, this.params.getOrtStart()));
        this.setZiel(this.getElem(zielSpalte, this.params.getOrtZiel()));
    }

    @Override
    public void setEdgesAll(boolean cartesianOnly) {
        TreeSet<Edge> eAll = new TreeSet<Edge>();
        TreeSet<Edge> eFound = new TreeSet<Edge>();
        TreeSet<Vertex> vS = this.getVS();
        for (Vertex v1 : vS) {
            for (Vertex v2 : vS.tailSet(v1, false)) {
                Edge e = new Edge(v1, v2);
                if (!cartesianOnly) {
                    eAll.add(e);
                    continue;
                }
                if (!e.isCartesian()) continue;
                eAll.add(e);
            }
        }
        Edge aktE = null;
        Edge nextE = null;
        for (Edge e1 : eAll) {
            if (aktE == null) {
                aktE = e1;
            } else if (nextE == null) {
                nextE = e1;
            } else {
                aktE = nextE;
                nextE = e1;
            }
            if (nextE != null && Util.isEqual(aktE.getWeight(), nextE.getWeight()) && this.rnd.nextInt(2) == 1) {
                Edge h = aktE;
                aktE = nextE;
                nextE = h;
            }
            boolean cuts = false;
            for (Edge e2 : eFound) {
                if (!aktE.cuts(e2)) continue;
                cuts = true;
                break;
            }
            if (cuts) continue;
            eFound.add(aktE);
        }
        for (Edge e : eFound) {
            this.addEdge(e);
        }
    }

    private Vertex getElem(SortedSet<Vertex> s, LabyParam.Ort o) {
        if (s == null) {
            throw new NullPointerException();
        }
        if (o == LabyParam.Ort.OBEN) {
            return s.last();
        }
        if (o == LabyParam.Ort.UNTEN) {
            return s.first();
        }
        int mitte = (int)((double)s.size() / 2.0);
        int i = 0;
        for (Vertex iV : s) {
            if (i++ != mitte) continue;
            return iV;
        }
        return null;
    }

    private SortedSet<Vertex> getVertexByColumn(double x) {
        TreeSet<Vertex> found = new TreeSet<Vertex>();
        for (Vertex iV : this.getVS()) {
            if (!Util.isEqual(iV.getX(), x)) continue;
            found.add(iV);
        }
        if (found.size() == 0) {
            found = null;
        }
        return found;
    }

    private void createLaby() {
        long lsgVersuchStart = System.currentTimeMillis();
        int lsgVersuche = 0;
        while (System.currentTimeMillis() - lsgVersuchStart < 10000L && this.isBadLsg()) {
            boolean hasLsg = this.initLsg();
            if (!hasLsg) {
                throw new IllegalStateException("Start und Zielknoten nicht miteinander verbindbar");
            }
            this.unmarkAll();
            ++lsgVersuche;
        }
        this.markLsgWegElems();
        this.delAdjStartZiel();
        this.initLsgSackgassen();
        this.initUnverbVertex();
        this.deleteUnmarkedEdges();
    }

    public LabyParam.Art getArt() {
        return this.getParams().getArt();
    }

    public List<Edge> getLsg() {
        return this.lsg;
    }
}

