/*
 * Decompiled with CFR 0.152.
 */
package com.thorstenfischer.util;

import java.io.PrintStream;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Random;

public class Util {
    private static final double FUZZY = 1.0E-10;
    public static final String FORMAT_DAUER = "%1$tM:%1$tS.%1$tL";
    public static final String FORMAT_DATUM_ZEIT_MILLIS = "%1$td.%1$tm.%1$tY %1$tH:%1$tM:%1$tS.%1$tL";
    public static final String FORMAT_DATUM = "%1$td.%1$tm.%1$tY";
    public static final String FORMAT_ZEIT_MILLIS = "%1$tH:%1$tM:%1$tS.%1$tL";
    public static final String FORMAT_DOUBLE_1000_2NK = "%1$,.2f";
    public static final String FORMAT_ZEIT = "%1$tH:%1$tM:%1$tS";

    public static final <E> E getRandomElem(Collection<E> c, Random rnd) {
        if (c == null) {
            return null;
        }
        if (c.size() == 0) {
            return null;
        }
        E item = null;
        int nr = rnd.nextInt(c.size());
        int i = 0;
        for (E iE : c) {
            if (i == nr) {
                item = iE;
                break;
            }
            ++i;
        }
        return item;
    }

    public static final void printCollection(Collection<?> c, PrintStream out, boolean enumerate) {
        if (c == null) {
            out.println("---null---");
            return;
        }
        if (c.size() == 0) {
            out.println("---keine Elemente---");
            return;
        }
        String formatS = "[%" + String.valueOf(String.valueOf(c.size()).length()).trim() + "d]";
        int i = 0;
        for (Object elem : c) {
            if (enumerate) {
                out.print(String.format(formatS, i++));
            }
            out.println(elem.toString());
        }
    }

    public static final void printCollection(Collection<?> c) {
        Util.printCollection(c, System.out, true);
    }

    public static final boolean isLesser(double a, double b) {
        return b - a > 1.0E-10;
    }

    public static final boolean isEqual(double a, double b) {
        return Math.abs(b - a) < 1.0E-10;
    }

    public static final boolean iInIntervals(double i1, double i1a, double i1b, double i2, double i2a, double i2b) {
        double h;
        if (i1a > i1b) {
            h = i1a;
            i1a = i1b;
            i1b = h;
        }
        if (i2a > i2b) {
            h = i2a;
            i2a = i2b;
            i2b = h;
        }
        return Util.isLesser(i1a, i1) && Util.isLesser(i1, i1b) && Util.isLesser(i2a, i2) && Util.isLesser(i2, i2b);
    }

    public static final boolean inRectangle(int x, int y, int lx, int rx, int oy, int uy) {
        if (lx > rx || oy > uy) {
            throw new IllegalArgumentException("Util.inRectangle: \u00dcbergabe falscher Koordinaten.");
        }
        return x >= lx && x <= rx && y >= oy && y <= uy;
    }

    public static final boolean intervalsIntersect(double a, double b, double c, double d) {
        double h;
        if (a > b) {
            h = a;
            a = b;
            b = h;
        }
        if (c > d) {
            h = c;
            c = d;
            d = h;
        }
        if (a > c) {
            h = a;
            a = c;
            c = h;
            h = b;
            b = d;
            d = h;
        }
        return Util.isLesser(c, b);
    }

    public static final String construct(String s, int cnt) {
        if (cnt == 0) {
            return "";
        }
        if (cnt < 0) {
            throw new IndexOutOfBoundsException("cnt < 0");
        }
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < cnt) {
            sb.append(s);
            ++i;
        }
        return sb.toString();
    }

    public static final String alignRight(String s, int cnt) {
        if (cnt == 0) {
            return "";
        }
        if (cnt < 0) {
            throw new IndexOutOfBoundsException("cnt < 0");
        }
        if (s.length() > cnt) {
            return s.substring(0, cnt);
        }
        if (s.length() == cnt) {
            return s;
        }
        return String.valueOf(Util.construct(" ", cnt - s.length())) + s;
    }

    public static void printNetworkAdapter() {
        Enumeration<NetworkInterface> nis = null;
        try {
            nis = NetworkInterface.getNetworkInterfaces();
            while (nis.hasMoreElements()) {
                NetworkInterface ni = nis.nextElement();
                System.out.println(ni.getDisplayName());
                System.out.println("isUp      = " + ni.isUp());
                System.out.println("isVirtual = " + ni.isVirtual());
                System.out.println("isPTP     = " + ni.isPointToPoint());
                System.out.println("isLoopback= " + ni.isLoopback());
                System.out.println("isSubint. = " + (ni.getParent() != null));
                System.out.println("IP-Addresses:");
                Enumeration<InetAddress> addresses = ni.getInetAddresses();
                while (addresses.hasMoreElements()) {
                    InetAddress address = addresses.nextElement();
                    System.out.println("getHostAddress()=" + address.getHostAddress());
                }
                System.out.println("-----------------------------------");
            }
        }
        catch (SocketException e) {
            e.printStackTrace();
            System.exit(1);
        }
    }

    public static void main(String[] args) {
        System.out.println("Hello world!");
    }
}

