/*
 * Decompiled with CFR 0.152.
 */
package com.thorstenfischer.util;

import com.thorstenfischer.util.Util;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;

public class Tree<E extends Comparable<? super E>>
implements Comparable<Tree<E>> {
    private E item = null;
    private Set<Tree<E>> nodes = null;
    private Tree<E> parent = null;

    public Tree() {
    }

    public Tree(E item) {
        this.item = item;
    }

    private Set<Tree<E>> initNodes() {
        return new TreeSet<Tree<E>>();
    }

    public E getItem() {
        return this.item;
    }

    private Set<Tree<E>> getNodes() {
        return this.nodes;
    }

    public Tree<E> getParent() {
        return this.parent;
    }

    private void setParent(Tree<E> parent) {
        this.parent = parent;
    }

    public void setItem(E item) {
        if (item == null) {
            throw new NullPointerException();
        }
        this.item = item;
    }

    public void addNodes(List<E> l) {
        if (l == null) {
            return;
        }
        if (l.size() == 0) {
            return;
        }
        for (Comparable item : l) {
            this.addNode(item);
        }
    }

    public Tree<E> addNode(E item) {
        boolean added;
        Tree<E> ret = new Tree<E>(item);
        super.setParent(this);
        if (this.nodes == null) {
            this.nodes = this.initNodes();
        }
        if (added = this.nodes.add(ret)) {
            return ret;
        }
        return this.getNodeByItem(item, false);
    }

    public Tree<E> getNodeByItem(E item) {
        return this.getNodeByItem(item, true);
    }

    public Tree<E> getNodeByItem(E item, boolean deepSearch) {
        Tree<E> ret = null;
        if (!deepSearch) {
            if (this.nodes == null) {
                return null;
            }
            for (Tree<E> n : this.nodes) {
                if (n.getItem() == null && item == null) {
                    ret = n;
                    break;
                }
                if (!n.getItem().equals(item)) continue;
                ret = n;
                break;
            }
            return ret;
        }
        List<Tree<E>> all = this.getNodesByItem(item, true);
        ret = all == null ? null : all.get(0);
        return ret;
    }

    private List<Tree<E>> getNodesByItem(E item, boolean single) {
        ArrayList<Tree<Tree>> ret = new ArrayList<Tree<Tree>>();
        for (Tree<E> k : this.nodes) {
            if (super.getNodes() != null) {
                List<Tree<E>> deepSearchL = super.getNodesByItem(item, single);
                if (deepSearchL != null) {
                    ret.addAll(deepSearchL);
                }
            } else {
                E i = k.getItem();
                if (i == null && item == null) {
                    ret.add(k);
                } else if (i != null && i.equals(item)) {
                    ret.add(k);
                }
            }
            if (ret != null && ret.size() > 0 && single) break;
        }
        if (this.getItem() == null && item == null) {
            ret.add(this);
        } else if (this.getItem() != null && this.getItem().equals(item)) {
            ret.add(this);
        }
        if (ret.size() == 0) {
            return null;
        }
        return ret;
    }

    public List<Tree<E>> getNodesByItem(E item) {
        return this.getNodesByItem(item, false);
    }

    public boolean isLeaf() {
        return this.nodes == null;
    }

    public boolean isRoot() {
        return this.parent == null;
    }

    public Tree<E> getRoot() {
        Tree<E> ret = this;
        while (ret.getParent() != null) {
            ret = ret.getParent();
        }
        return ret;
    }

    public List<Tree<E>> getLeaves(boolean deepSearch) {
        if (this.nodes == null) {
            return null;
        }
        ArrayList<Tree<Tree<E>>> ret = new ArrayList<Tree<Tree<E>>>();
        for (Tree<E> k : this.nodes) {
            if (super.getNodes() != null && deepSearch) {
                List<Tree<E>> deepSearchL = k.getLeaves(true);
                if (deepSearchL == null) continue;
                ret.addAll(deepSearchL);
                continue;
            }
            if (super.getNodes() != null) continue;
            ret.add(k);
        }
        return ret;
    }

    public List<Tree<E>> getLeaves() {
        return this.getLeaves(true);
    }

    public List<E> toList(boolean deepSearch, boolean includeRoot) {
        if (this.nodes == null) {
            return null;
        }
        ArrayList<E> ret = new ArrayList<E>();
        for (Tree<E> k : this.nodes) {
            if (super.getNodes() != null && deepSearch) {
                List<E> deepSearchL = k.toList(true, true);
                if (deepSearchL == null) continue;
                ret.addAll(deepSearchL);
                continue;
            }
            E item = k.getItem();
            if (item == null) continue;
            ret.add(item);
        }
        if (this.getItem() != null && includeRoot) {
            ret.add(this.getItem());
        }
        if (ret.size() == 0) {
            return null;
        }
        return ret;
    }

    public List<E> toList() {
        return this.toList(true, false);
    }

    public List<E> pathToRoot() {
        ArrayList<E> ret = new ArrayList<E>();
        Tree<E> act = this;
        while (act != null) {
            E i = act.getItem();
            if (i != null) {
                ret.add(i);
            }
            act = act.getParent();
        }
        if (ret.size() == 0) {
            ret = null;
        }
        return ret;
    }

    public List<E> pathTo() {
        List<E> ret = this.pathToRoot();
        if (ret != null) {
            Collections.reverse(ret);
        }
        return ret;
    }

    public void print(PrintStream out, int offs) {
        if (this.item != null) {
            out.println(this.item.toString());
        } else {
            out.println("---");
        }
        this.print(out, this, offs, offs);
    }

    private void print(PrintStream out, Tree<E> tree, int ebene, int offs) {
        if (super.getNodes() != null) {
            for (Tree<E> t : super.getNodes()) {
                out.println(String.valueOf(Util.construct(" ", ebene)) + t.getItem());
                this.print(out, t, ebene + offs, offs);
            }
        }
    }

    public boolean equals(Object o) {
        if (!(o instanceof Tree)) {
            return false;
        }
        if (this.item == null) {
            return o == null;
        }
        return this.item.equals(((Tree)o).getItem());
    }

    public int hashCode() {
        if (this.item == null) {
            return 0;
        }
        return this.item.hashCode();
    }

    public String toString() {
        if (this.item == null) {
            return "null";
        }
        return this.item.toString();
    }

    @Override
    public int compareTo(Tree<E> t) {
        if (this.item == null && t.getItem() != null) {
            return -1;
        }
        if (this.item == null && t.getItem() == null) {
            return 0;
        }
        return this.item.compareTo(t.getItem());
    }
}

