/*
 * Decompiled with CFR 0.152.
 */
package com.thorstenfischer.util;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;

public final class PerfMesser {
    private static final String FORMAT_DAUER = "%1$tM:%1$tS.%1$tL";
    private static ArrayList<Zeitstempel> zSt = new ArrayList();
    private static PerfMesser instance = new PerfMesser();

    private PerfMesser() {
    }

    public static void trace(String id, Trace t) {
        PerfMesser perfMesser = instance;
        perfMesser.getClass();
        Zeitstempel z = perfMesser.new Zeitstempel(id, t);
        zSt.add(z);
    }

    private static void printRAW(PrintStream out) {
        Collections.sort(zSt);
        for (Zeitstempel z : zSt) {
            out.println(z.toString());
        }
    }

    private static void printDURATION(PrintStream out) {
        Comparator<Zeitstempel> comp = new Comparator<Zeitstempel>(){

            @Override
            public int compare(Zeitstempel z1, Zeitstempel z2) {
                int ret = 0;
                ret = z1.id.compareTo(z2.id);
                if (ret != 0) {
                    return ret;
                }
                ret = z1.compareTo(z2);
                if (ret != 0) {
                    return ret;
                }
                if (z1.t.ordinal() < z2.t.ordinal()) {
                    return -1;
                }
                if (z1.t.ordinal() > z2.t.ordinal()) {
                    return 1;
                }
                return 0;
            }
        };
        Collections.sort(zSt, comp);
        HashMap<String, Long> dauer = new HashMap<String, Long>();
        for (Zeitstempel z : zSt) {
            long anf = 0L;
            long diff = 0L;
            if (z.t == Trace.START) {
                anf = z.millis;
                continue;
            }
            if (z.t != Trace.STOP) continue;
            diff = z.millis - anf;
            Long d = (Long)dauer.get(z.id);
            if (d != null) {
                d = new Long(d + diff);
                continue;
            }
            dauer.put(z.id, new Long(diff));
        }
        for (String id : dauer.keySet()) {
            StringBuilder sb = new StringBuilder();
            sb.append(id).append(";").append(String.format(FORMAT_DAUER, dauer.get(id)));
            out.println(sb.toString());
        }
    }

    public static void print(PrintStream out, PrintType pt) {
        switch (pt) {
            case RAW: {
                PerfMesser.printRAW(out);
                break;
            }
            case DURATION: {
                PerfMesser.printDURATION(out);
            }
        }
    }

    public static enum PrintType {
        RAW,
        DURATION;

    }

    public static enum Trace {
        START,
        STOP;

    }

    private final class Zeitstempel
    implements Comparable<Zeitstempel> {
        protected String id;
        protected Trace t;
        protected long millis;

        private Zeitstempel() {
        }

        public Zeitstempel(String id, Trace t) {
            this.millis = System.currentTimeMillis();
            this.id = id;
            this.t = t;
        }

        @Override
        public int compareTo(Zeitstempel z) {
            if (this.millis < z.millis) {
                return -1;
            }
            if (this.millis > z.millis) {
                return 1;
            }
            return 0;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            return sb.append(this.id).append(";").append((Object)this.t).append(";").append(this.millis).toString();
        }
    }
}

