/*
 * Decompiled with CFR 0.152.
 */
package com.thorstenfischer.util;

import com.thorstenfischer.util.DefaultEdgeFactory;
import com.thorstenfischer.util.DefaultVertexFactory;
import com.thorstenfischer.util.Edge;
import com.thorstenfischer.util.EdgeFactory;
import com.thorstenfischer.util.Vertex;
import com.thorstenfischer.util.VertexFactory;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;

public class Graph<V extends Vertex, E extends Edge<V>> {
    private EdgeFactory<V, E> eFactory = new DefaultEdgeFactory();
    private VertexFactory<V> vFactory = new DefaultVertexFactory();
    private final TreeSet<V> vS = new TreeSet();
    private final TreeSet<E> eS = new TreeSet();
    private final TreeMap<V, Set<E>> adj = new TreeMap();
    private double minX = Double.MAX_VALUE;
    private double minY = Double.MAX_VALUE;
    private double maxX = Double.MIN_VALUE;
    private double maxY = Double.MIN_VALUE;

    public Graph() {
    }

    public Graph(VertexFactory<V> vFactory, EdgeFactory<V, E> eFactory) {
        this();
        this.eFactory = eFactory;
        this.vFactory = vFactory;
    }

    public boolean addVertex(V v) {
        if (v == null) {
            throw new NullPointerException();
        }
        boolean ret = this.vS.add(v);
        if (ret) {
            double x = v.getX();
            double y = v.getY();
            if (x < this.minX) {
                this.minX = x;
            }
            if (x > this.maxX) {
                this.maxX = x;
            }
            if (y < this.minY) {
                this.minY = y;
            }
            if (y > this.maxY) {
                this.maxY = y;
            }
        }
        return ret;
    }

    public E addEdge(V v1, V v2, boolean directed) {
        if (v1 == null || v2 == null) {
            throw new NullPointerException();
        }
        E e = this.eFactory.createEdge(v1, v2, directed);
        return this.addEdge(e);
    }

    public E addEdge(E e) {
        if (e == null) {
            throw new NullPointerException();
        }
        Object v1 = e.getV1();
        Object v2 = e.getV2();
        if (!this.eS.add(e)) {
            e = (Edge)this.eS.ceiling(e);
        } else {
            if (!this.vS.contains(v1)) {
                this.addVertex(v1);
            }
            if (!this.vS.contains(v2)) {
                this.addVertex(v2);
            }
            Object aV = v1;
            int i = 0;
            while (i <= (e.isDirected() ? 1 : 2)) {
                Set<Object> s = this.adj.get(aV);
                if (s == null) {
                    s = new TreeSet();
                }
                s.add(e);
                this.adj.put((Set<Object>)aV, s);
                if (!e.isDirected()) {
                    aV = v2;
                }
                ++i;
            }
        }
        return (E)e;
    }

    public void print(PrintStream out, boolean verbose) {
        if (verbose) {
            out.println("Die Knotenliste (" + this.vS.size() + " St\u00fcck) :");
            for (Vertex v : this.vS) {
                out.println(v + (v.isMarked() ? " marked" : " unmarked"));
            }
            out.println("Die Kantenliste (" + this.eS.size() + " St\u00fcck) :");
            for (Edge e : this.eS) {
                out.println(e + (e.isMarked() ? " marked" : " unmarked"));
            }
        }
        out.println("Die Adjazenzliste");
        int vAnz = 0;
        int eAnz = 0;
        for (Vertex v : this.adj.keySet()) {
            out.print("Knoten " + v + "/ ");
            for (Edge e : this.adj.get(v)) {
                out.print(String.valueOf(e.toString(v)) + "/ ");
                ++eAnz;
            }
            out.println();
            ++vAnz;
        }
        out.println("Anzahl Knoten: " + vAnz + " Anzahl Kanten: " + eAnz);
    }

    public E addEdge(V v1, V v2) {
        return this.addEdge(v1, v2, false);
    }

    public void unmarkAll() {
        this.unmarkEdges();
        this.unmarkVertex();
    }

    public void unmarkEdges() {
        for (Edge e : this.eS) {
            e.setMarked(false);
        }
    }

    public void unmarkVertex() {
        for (Vertex v : this.vS) {
            v.setMarked(false);
        }
    }

    public int getCountEdges(boolean marked) {
        int i = 0;
        if (this.eS == null) {
            return 0;
        }
        for (Edge e : this.eS) {
            if (e.isMarked() != marked) continue;
            ++i;
        }
        return i;
    }

    public int getCountEdges(V v, boolean marked) {
        int i = 0;
        Set<E> adjE = this.getAdjEdges(v);
        if (adjE == null) {
            return 0;
        }
        for (Edge e : adjE) {
            if (e.isMarked() != marked) continue;
            ++i;
        }
        return i;
    }

    public int getCountMinV(V v, boolean marked) {
        int i = Integer.MAX_VALUE;
        Set<E> adjE = this.getAdjEdges(v);
        if (adjE == null) {
            return 0;
        }
        for (Edge e : adjE) {
            int anz = this.getCountEdges(e.getDestVertex(v), marked);
            if (anz >= i) continue;
            i = anz;
        }
        return i;
    }

    public int getCountMinMarkedV(V v, boolean markedV, boolean markedE) {
        int i = Integer.MAX_VALUE;
        Set<V> adjV = this.getAdjVertex(v, markedV);
        if (adjV == null) {
            return 0;
        }
        for (Vertex iV : adjV) {
            int anz = this.getCountEdges(iV, markedE);
            if (anz >= i) continue;
            i = anz;
        }
        return i;
    }

    public int getCountVertex(boolean marked) {
        int i = 0;
        for (Vertex v : this.vS) {
            if (v.isMarked() != marked) continue;
            ++i;
        }
        return i;
    }

    public int getCountVertex(V v, boolean marked) {
        int i = 0;
        Set<E> adjE = this.getAdjEdges(v);
        for (Edge iE : adjE) {
            if (iE.getDestVertex(v).isMarked() != marked) continue;
            ++i;
        }
        return i;
    }

    public int getCountEdges() {
        return this.eS.size();
    }

    public int getCountVertex() {
        return this.vS.size();
    }

    public TreeSet<V> getVS() {
        return this.vS;
    }

    public double getMaxY() {
        return this.maxY;
    }

    public double getMinX() {
        return this.minX;
    }

    public double getMaxX() {
        return this.maxX;
    }

    public double getMinY() {
        return this.minY;
    }

    public TreeSet<E> getES() {
        return this.eS;
    }

    public Set<E> getAdjEdges(V v) {
        Set<E> ret = this.adj.get(v);
        if (ret == null) {
            return null;
        }
        if (ret.size() == 0) {
            return null;
        }
        return ret;
    }

    public Set<E> getAdjEdges(V v, boolean marked) {
        Set<E> ret = this.adj.get(v);
        if (ret == null) {
            return null;
        }
        if (ret.size() == 0) {
            return null;
        }
        TreeSet<Edge> founds = new TreeSet<Edge>();
        for (Edge iE : ret) {
            if (iE.isMarked() != marked) continue;
            founds.add(iE);
        }
        if (founds == null) {
            return null;
        }
        if (founds.size() == 0) {
            return null;
        }
        return founds;
    }

    public Set<V> getAdjVertex(V v) {
        Set<E> adjEdge = this.getAdjEdges(v);
        if (adjEdge == null) {
            return null;
        }
        TreeSet<V> adjV = new TreeSet<V>();
        for (Edge e : adjEdge) {
            adjV.add(e.getDestVertex(v));
        }
        if (adjV.size() == 0) {
            return null;
        }
        return adjV;
    }

    public Set<V> getAdjVertex(V v, boolean marked) {
        Set<E> adjEdge = this.getAdjEdges(v);
        if (adjEdge == null) {
            return null;
        }
        TreeSet<V> adjV = new TreeSet<V>();
        for (Edge e : adjEdge) {
            V aV = e.getDestVertex(v);
            if (!aV.isMarked()) continue;
            adjV.add(aV);
        }
        if (adjV.size() == 0) {
            return null;
        }
        return adjV;
    }

    public boolean contains(V v) {
        return this.vS.contains(v);
    }

    public boolean contains(E e) {
        return this.eS.contains(e);
    }

    public V getVertex(double x, double y) {
        V sV = this.vFactory.createVertex(x, y);
        Vertex v = (Vertex)this.vS.ceiling(sV);
        if (!((Object)v).equals(sV)) {
            return null;
        }
        return (V)v;
    }

    public List<V> getVertex(boolean marked) {
        ArrayList<Vertex> ret = new ArrayList<Vertex>();
        for (Vertex iV : this.vS) {
            if (iV.isMarked() != marked) continue;
            ret.add(iV);
        }
        if (ret.size() == 0) {
            return null;
        }
        return ret;
    }

    public List<E> getEdge(boolean marked) {
        ArrayList<Edge> ret = new ArrayList<Edge>();
        for (Edge iE : this.eS) {
            if (iE.isMarked() != marked) continue;
            ret.add(iE);
        }
        if (ret.size() == 0) {
            return null;
        }
        return ret;
    }

    public E getEdge(V v1, V v2, boolean directed) {
        Edge ret = null;
        E e = this.eFactory.createEdge(v1, v2, directed);
        if (this.eS.contains(e)) {
            ret = (Edge)this.eS.ceiling(e);
        }
        return (E)ret;
    }

    public boolean deleteEdge(E e) {
        Set<E> v2S;
        if (e == null) {
            throw new NullPointerException();
        }
        Object v1 = e.getV1();
        Object v2 = e.getV2();
        boolean ret = this.eS.remove(e);
        Set<E> v1S = this.adj.get(v1);
        if (v1S != null) {
            v1S.remove(e);
        }
        if ((v2S = this.adj.get(v2)) != null) {
            v2S.remove(e);
        }
        return ret;
    }

    public void deleteAdjEdges(V v, boolean markedE) {
        Set<E> rm = null;
        rm = this.getAdjEdges(v, markedE);
        if (rm != null) {
            for (Edge iE : rm) {
                this.deleteEdge(iE);
            }
        }
    }

    public boolean deleteUnmarkedEdges() {
        List<E> mE = this.getEdge(false);
        boolean success = true;
        for (Edge iE : mE) {
            boolean bl = success = success && this.deleteEdge(iE);
        }
        return success;
    }

    public void setEdgesAll(boolean cartesianOnly) {
        TreeSet<E> eAll = new TreeSet<E>();
        TreeSet<Edge> eFound = new TreeSet<Edge>();
        TreeSet<V> vS = this.getVS();
        for (Vertex v1 : vS) {
            for (Vertex v2 : vS.tailSet(v1, false)) {
                E e = this.eFactory.createEdge(v1, v2);
                if (!cartesianOnly) {
                    eAll.add(e);
                    continue;
                }
                if (!e.isCartesian()) continue;
                eAll.add(e);
            }
        }
        for (Edge e1 : eAll) {
            boolean cuts = false;
            for (Edge e2 : eFound) {
                if (!e1.cuts(e2)) continue;
                cuts = true;
                break;
            }
            if (cuts) continue;
            eFound.add(e1);
        }
        for (Edge e : eFound) {
            this.addEdge(e);
        }
    }

    public void setVertexRandom(Random r, int minX, int minY, int maxX, int maxY, int anz) {
        int i = 0;
        while (i < anz) {
            V v;
            while (!this.addVertex(v = this.vFactory.createVertex(r.nextInt(Math.abs(maxX - minX + 1)) + minX, r.nextInt(Math.abs(maxY - minY + 1)) + minY))) {
            }
            ++i;
        }
    }

    public void setVertexChecked(int anzX, int anzY) {
        int x = 1;
        while (x <= anzX) {
            int y = 1;
            while (y <= anzY) {
                this.addVertex(this.vFactory.createVertex(x, y));
                ++y;
            }
            ++x;
        }
    }

    public boolean existsEdge(double v1x, double v1y, double v2x, double v2y) {
        V v1 = this.vFactory.createVertex(v1x, v1y);
        V v2 = this.vFactory.createVertex(v2x, v2y);
        E e = this.eFactory.createEdge(v1, v2);
        return this.contains(e);
    }

    public EdgeFactory<V, E> getEFactory() {
        return this.eFactory;
    }

    public VertexFactory<V> getVFactory() {
        return this.vFactory;
    }
}

