/*
 * Decompiled with CFR 0.152.
 */
package com.thorstenfischer.util;

import com.thorstenfischer.util.DefaultPaintable;
import com.thorstenfischer.util.DefaultVertex;
import com.thorstenfischer.util.Edge;
import com.thorstenfischer.util.Util;
import com.thorstenfischer.util.Vertex;

public class DefaultEdge<V extends Vertex>
extends DefaultPaintable
implements Edge<V> {
    private double weight = 0.0;
    private double a;
    private double b;
    private V v1;
    private V v2;
    private boolean directed = false;
    private boolean marked = false;

    public DefaultEdge(V v1, V v2, boolean directed) {
        if (v1 == null || v2 == null) {
            throw new NullPointerException();
        }
        if (v1.equals(v2)) {
            throw new IllegalArgumentException("Kante zwischen identischen Knoten");
        }
        this.weight = DefaultVertex.distance(v1, v2);
        this.v1 = v1;
        this.v2 = v2;
        this.directed = directed;
        if (v2.getX() - v1.getX() == 0.0) {
            this.a = Double.NaN;
            this.b = v1.getX();
        } else {
            this.a = (v2.getY() - v1.getY()) / (v2.getX() - v1.getX());
            this.b = v1.getY() - v1.getX() * this.a;
        }
    }

    public DefaultEdge(V v1, V v2) {
        this(v1, v2, false);
    }

    @Override
    public int compareTo(Edge<V> e) {
        if (this.equals(e)) {
            return 0;
        }
        if (this.isDirected() != e.isDirected()) {
            return this.isDirected() ? -1 : 1;
        }
        if (this.getWeight() != e.getWeight()) {
            return this.getWeight() < e.getWeight() ? -1 : 1;
        }
        if (this.isDirected()) {
            if (!this.getV1().equals(e.getV1())) {
                return this.getV1().compareTo((Vertex)e.getV1());
            }
            return this.getV2().compareTo((Vertex)e.getV2());
        }
        V vke = e.getLesserVertex();
        V vge = e.getGreaterVertex();
        V vkt = this.getLesserVertex();
        V vgt = this.getGreaterVertex();
        if (!vkt.equals(vke)) {
            return vkt.compareTo((Vertex)vke);
        }
        return vgt.compareTo((Vertex)vge);
    }

    @Override
    public V getLesserVertex() {
        return this.v1.compareTo((Vertex)this.v2) < 0 ? this.v1 : this.v2;
    }

    @Override
    public V getGreaterVertex() {
        return this.v1.compareTo((Vertex)this.v2) > 0 ? this.v1 : this.v2;
    }

    @Override
    public double getWeight() {
        return this.weight;
    }

    @Override
    public boolean equals(Object o) {
        if (o == null) {
            throw new NullPointerException();
        }
        if (!(o instanceof Edge)) {
            return false;
        }
        Edge e = (Edge)o;
        if (e.isDirected() != this.directed) {
            return false;
        }
        if (this.directed) {
            return this.v1.equals(e.getV1()) && this.v2.equals(e.getV2());
        }
        return this.v1.equals(e.getV1()) && this.v2.equals(e.getV2()) || this.v1.equals(e.getV2()) && this.v2.equals(e.getV1());
    }

    private String toShortString() {
        return String.valueOf(this.v1.toString()) + (this.directed ? "->" : "<->") + this.v2.toString();
    }

    private String toShortString(Vertex srcNode) {
        String ret = this.toShortString();
        ret = this.v1.equals(srcNode) ? String.valueOf(ret) + "Z" : "Z" + ret;
        return ret;
    }

    private String toLongString(String shortS) {
        return "(" + shortS + ";" + String.format("%.2f", this.weight) + ")";
    }

    @Override
    public String toString() {
        return this.toLongString(this.toShortString());
    }

    @Override
    public String toString(Vertex v) {
        return this.toLongString(this.toShortString(v));
    }

    @Override
    public boolean isDirected() {
        return this.directed;
    }

    @Override
    public int hashCode() {
        return this.toString().hashCode();
    }

    @Override
    public V getV1() {
        return this.v1;
    }

    @Override
    public V getV2() {
        return this.v2;
    }

    @Override
    public double getA() {
        return this.a;
    }

    @Override
    public double getB() {
        return this.b;
    }

    @Override
    public V getDestVertex(V srcVertex) {
        if (srcVertex == null) {
            throw new NullPointerException();
        }
        if (this.v1.equals(srcVertex)) {
            return this.v2;
        }
        if (!this.directed && this.v2.equals(srcVertex)) {
            return this.v1;
        }
        throw new IllegalArgumentException(String.valueOf(srcVertex.toString()) + " nicht in " + this.toString());
    }

    @Override
    public V getSrcVertex(V destVertex) {
        if (destVertex == null) {
            throw new NullPointerException();
        }
        if (this.v2.equals(destVertex)) {
            return this.v1;
        }
        if (!this.directed && this.v1.equals(destVertex)) {
            return this.v2;
        }
        throw new IllegalArgumentException(String.valueOf(destVertex.toString()) + " nicht in " + this.toString());
    }

    @Override
    public boolean cuts(Edge<V> e) {
        double i2b;
        double i2a;
        double i2;
        double i1b;
        double i1a;
        double i1;
        if (e == null) {
            throw new NullPointerException();
        }
        if (this.equals(e)) {
            return true;
        }
        double c = e.getA();
        double d = e.getB();
        double m = this.a;
        double f = this.b;
        if (c == m || Double.isNaN(c) && Double.isNaN(m)) {
            double i2b2;
            double i2a2;
            double i1b2;
            double i1a2;
            if (d != f) {
                return false;
            }
            if (Double.isNaN(m)) {
                i1a2 = this.v1.getY();
                i1b2 = this.v2.getY();
                i2a2 = e.getV1().getY();
                i2b2 = e.getV2().getY();
            } else {
                i1a2 = this.v1.getX();
                i1b2 = this.v2.getX();
                i2a2 = e.getV1().getX();
                i2b2 = e.getV2().getX();
            }
            return Util.intervalsIntersect(i1a2, i1b2, i2a2, i2b2);
        }
        if (Double.isNaN(c) && m == 0.0) {
            double sy;
            double sx = e.getB();
            i1 = sy = this.getB();
            i1a = e.getV1().getY();
            i1b = e.getV2().getY();
            i2 = sx;
            i2a = this.v1.getX();
            i2b = this.v2.getX();
        } else if (c == 0.0 && Double.isNaN(m)) {
            double sy;
            double sx = this.getB();
            i1 = sy = e.getB();
            i1a = this.v1.getY();
            i1b = this.v2.getY();
            i2 = sx;
            i2a = e.getV1().getX();
            i2b = e.getV2().getX();
        } else if (Double.isNaN(c) && m != 0.0) {
            double sy;
            double sx = d;
            i1 = sy = m * sx + f;
            i1a = e.getV1().getY();
            i1b = e.getV2().getY();
            i2 = sx;
            i2a = this.v1.getX();
            i2b = this.v2.getX();
        } else if (Double.isNaN(m) && c != 0.0) {
            double sy;
            double sx = f;
            i1 = sy = c * sx + d;
            i1a = this.v1.getY();
            i1b = this.v2.getY();
            i2 = sx;
            i2a = e.getV1().getX();
            i2b = e.getV2().getX();
        } else {
            double sx = (d - f) / (m - c);
            double sy = m * sx + f;
            i1 = sx;
            i1a = this.v1.getX();
            i1b = this.v2.getX();
            i2 = sx;
            i2a = e.getV1().getX();
            i2b = e.getV2().getX();
        }
        return Util.iInIntervals(i1, i1a, i1b, i2, i2a, i2b);
    }

    @Override
    public boolean isCartesian() {
        return Double.isNaN(this.a) || Util.isEqual(this.a, 0.0);
    }

    @Override
    public boolean isMarked() {
        return this.marked;
    }

    @Override
    public void setMarked(boolean marked) {
        this.marked = marked;
    }
}

