/*
 * Decompiled with CFR 0.152.
 */
package com.thorstenfischer.util;

import com.thorstenfischer.util.CommProtocol;
import com.thorstenfischer.util.ConnectionListener;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public abstract class CommBuffer {
    protected BufferedWriter out = null;
    protected BufferedReader in = null;
    private final List<String> inMsg = Collections.synchronizedList(new ArrayList());
    private final List<String> outMsg = Collections.synchronizedList(new ArrayList());
    protected int port;
    protected Socket client = null;
    private long millis = 1000L;
    private boolean stop;
    private CommProtocol prot = null;
    protected boolean running = false;
    protected ConnectionListener connectionListener = null;
    private String rest = "";

    private CommBuffer() {
    }

    protected CommBuffer(int port, long millis, CommProtocol prot) {
        this.port = port;
        this.millis = millis;
        this.prot = prot;
    }

    public void addConnectionListener(ConnectionListener connectionListener) {
        this.connectionListener = connectionListener;
    }

    public boolean isRunning() {
        return this.running;
    }

    public final void setStop() {
        this.stop = true;
        if (this.isRunning()) {
            this.flush();
        }
    }

    public final synchronized void flush() {
        boolean didReceive = this.receive(0);
        if (didReceive) {
            this.prot.receive();
        }
        this.send();
    }

    public final int getPort() {
        return this.port;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void send() {
        block6: {
            try {
                List<String> list = this.outMsg;
                synchronized (list) {
                    for (String msg : this.outMsg) {
                        this.out.write(String.valueOf(msg) + "\n");
                        this.out.flush();
                    }
                    this.outMsg.clear();
                }
            }
            catch (IOException e) {
                if (this.connectionListener == null) break block6;
                this.connectionListener.connectionFailed(e);
            }
        }
    }

    protected final void send(String msg) {
        this.outMsg.add(msg);
    }

    private final boolean receive(int dummy) {
        boolean ret = false;
        try {
            int av = this.client.getInputStream().available();
            if (av != 0) {
                StringBuilder sb = new StringBuilder(this.rest);
                while (this.in.ready()) {
                    sb.append((char)this.in.read());
                }
                String[] msg = sb.toString().split("\n");
                int cnt = sb.charAt(sb.length() - 1) == '\n' ? 0 : -1;
                int i = 0;
                while (i < msg.length + cnt) {
                    this.inMsg.add(msg[i]);
                    ++i;
                }
                if (cnt == -1) {
                    this.rest = msg[msg.length - 1];
                }
                ret = true;
            } else {
                ret = false;
            }
        }
        catch (IOException e) {
            if (this.connectionListener != null) {
                this.connectionListener.connectionFailed(e);
            }
            ret = false;
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final String[] receive() {
        String[] ret = null;
        List<String> list = this.inMsg;
        synchronized (list) {
            ret = new String[this.inMsg.size()];
            this.inMsg.toArray(ret);
            this.inMsg.clear();
        }
        return ret;
    }

    public void run() {
        try {
            while (!this.stop) {
                this.flush();
                Thread.sleep(this.millis);
            }
        }
        catch (InterruptedException e) {
            if (this.connectionListener != null) {
                this.connectionListener.connectionFailed(e);
            }
            this.running = false;
        }
    }

    public abstract void stop();
}

