/*
 * Decompiled with CFR 0.152.
 */
package com.thorstenfischer.util;

import com.thorstenfischer.util.CommBuffer;
import com.thorstenfischer.util.CommProtocol;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.InetAddress;
import java.net.ServerSocket;

public class ChatServer
extends CommBuffer
implements Runnable {
    private ServerSocket server = null;
    private boolean forceStop = false;

    public ChatServer(int port, long millis, CommProtocol prot) throws IOException {
        super(port, millis, prot);
        if (prot == null) {
            throw new IllegalArgumentException("ChatServer<init>: prot darf nicht null sein");
        }
        this.server = new ServerSocket(port, 0, InetAddress.getLocalHost());
    }

    public String getIp() {
        return this.server.getInetAddress().getHostAddress();
    }

    @Override
    public void run() {
        try {
            this.client = this.server.accept();
            this.out = new BufferedWriter(new OutputStreamWriter(this.client.getOutputStream()));
            this.in = new BufferedReader(new InputStreamReader(this.client.getInputStream()));
        }
        catch (IOException e) {
            if (this.connectionListener != null && !this.forceStop) {
                this.connectionListener.connectionFailed(e);
            }
            this.running = false;
            return;
        }
        this.running = true;
        if (this.connectionListener != null) {
            this.connectionListener.connectionAccepted();
        }
        super.run();
    }

    @Override
    public void stop() {
        this.setStop();
        this.forceStop = true;
        this.running = false;
        this.closeAll();
    }

    private void closeAll() {
        try {
            this.in.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.out.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.client.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.server.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.closeAll();
    }
}

