/*
 * Decompiled with CFR 0.152.
 */
package com.thorstenfischer.util;

import com.thorstenfischer.util.CommBuffer;
import com.thorstenfischer.util.CommProtocol;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.ConnectException;
import java.net.Socket;
import java.net.UnknownHostException;

public class ChatClient
extends CommBuffer
implements Runnable {
    public ChatClient(String ip, int port, long millis, CommProtocol prot) throws ConnectException, UnknownHostException, IOException {
        super(port, millis, prot);
        if (prot == null) {
            throw new IllegalArgumentException("ChatServer<init>: prot darf nicht null sein");
        }
        this.client = new Socket(ip, port);
        this.in = new BufferedReader(new InputStreamReader(this.client.getInputStream()));
        this.out = new BufferedWriter(new OutputStreamWriter(this.client.getOutputStream()));
        this.running = true;
    }

    @Override
    public void run() {
        super.run();
    }

    @Override
    public void stop() {
        this.setStop();
        this.closeAll();
    }

    private void closeAll() {
        try {
            this.out.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            this.in.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            this.client.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.closeAll();
    }
}

