/*
 * Decompiled with CFR 0.152.
 */
package com.thorstenfischer.ui;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.PixelGrabber;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.UnsupportedAudioFileException;
import javax.swing.ImageIcon;
import javax.swing.UIManager;

public class Util {
    public static final int TRANSP_DEFAULT_OFFS = 50;

    public static void setPlatformLaf() {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
        }
    }

    public static void center(Component c) {
        Dimension ds = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dc = c.getSize();
        c.setLocation(ds.width / 2 - dc.width / 2, ds.height / 2 - dc.height / 2);
    }

    public static BufferedImage transparent(BufferedImage src, Color c) {
        return Util.transparent(src, c, 0);
    }

    public static BufferedImage transparentBlack(BufferedImage src) {
        return Util.transparent(src, Color.BLACK, 50);
    }

    public static BufferedImage transparentWhite(BufferedImage src) {
        return Util.transparent(src, Color.WHITE, 50);
    }

    public static BufferedImage transparent(BufferedImage src, Color c, int offs) {
        if (src == null) {
            throw new NullPointerException("Util.transparent: src darf nicht null sein.");
        }
        if (c == null) {
            throw new NullPointerException("Util.transparent: c darf nicht null sein.");
        }
        if (offs < 0) {
            throw new IllegalArgumentException("Util.transparent: offs mu\u00df >= 0 sein.");
        }
        BufferedImage ret = new BufferedImage(src.getWidth(), src.getHeight(), 2);
        Graphics2D g = ret.createGraphics();
        ColorModel cm = ret.getColorModel();
        int cr = c.getRed();
        int cg = c.getGreen();
        int cb = c.getBlue();
        g.setComposite(AlphaComposite.Src);
        g.drawImage(src, null, 0, 0);
        int y = 0;
        while (y < ret.getHeight()) {
            int x = 0;
            while (x < ret.getWidth()) {
                if (offs == 0) {
                    if (ret.getRGB(x, y) == c.getRGB()) {
                        ret.setRGB(x, y, 9378844);
                    }
                } else {
                    int px = ret.getRGB(x, y);
                    if (Math.abs(cm.getRed(px) - cr) < offs && Math.abs(cm.getGreen(px) - cg) < offs && Math.abs(cm.getBlue(px) - cb) < offs) {
                        ret.setRGB(x, y, 9378844);
                    }
                }
                ++x;
            }
            ++y;
        }
        return ret;
    }

    public static boolean hasAlpha(Image image) {
        if (image instanceof BufferedImage) {
            BufferedImage bimage = (BufferedImage)image;
            return bimage.getColorModel().hasAlpha();
        }
        PixelGrabber pg = new PixelGrabber(image, 0, 0, 1, 1, false);
        try {
            pg.grabPixels();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        ColorModel cm = pg.getColorModel();
        return cm.hasAlpha();
    }

    public static BufferedImage toBufferedImage(Image image) {
        if (image instanceof BufferedImage) {
            return (BufferedImage)image;
        }
        image = new ImageIcon(image).getImage();
        boolean hasAlpha = Util.hasAlpha(image);
        BufferedImage bimage = null;
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        try {
            int transparency = 1;
            if (hasAlpha) {
                transparency = 2;
            }
            GraphicsDevice gs = ge.getDefaultScreenDevice();
            GraphicsConfiguration gc = gs.getDefaultConfiguration();
            bimage = gc.createCompatibleImage(image.getWidth(null), image.getHeight(null), transparency);
        }
        catch (HeadlessException transparency) {
            // empty catch block
        }
        if (bimage == null) {
            int type = 1;
            if (hasAlpha) {
                type = 2;
            }
            bimage = new BufferedImage(image.getWidth(null), image.getHeight(null), type);
        }
        Graphics2D g = bimage.createGraphics();
        g.drawImage(image, 0, 0, null);
        g.dispose();
        return bimage;
    }

    public static Image loadImage(Class<?> res, String path) {
        return Toolkit.getDefaultToolkit().getImage(res.getClass().getResource(path));
    }

    public static BufferedImage loadBufferedImage(Class<?> res, String path) {
        return Util.toBufferedImage(Util.loadImage(res, path));
    }

    public static ImageIcon loadImageIcon(Class<?> res, String path) {
        return new ImageIcon(res.getResource(path));
    }

    public static Clip loadClip(URL url) {
        Clip clip = null;
        try {
            AudioInputStream stream = AudioSystem.getAudioInputStream(url);
            AudioFormat format = stream.getFormat();
            DataLine.Info info = new DataLine.Info(Clip.class, stream.getFormat(), (int)stream.getFrameLength() * format.getFrameSize());
            clip = (Clip)AudioSystem.getLine(info);
            clip.open(stream);
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            System.exit(1);
        }
        catch (IOException e) {
            e.printStackTrace();
            System.exit(1);
        }
        catch (LineUnavailableException e) {
            e.printStackTrace();
            System.exit(1);
        }
        catch (UnsupportedAudioFileException e) {
            e.printStackTrace();
            System.exit(1);
        }
        return clip;
    }

    public static Clip loadClip(Class<?> res, String path) {
        return Util.loadClip(res.getResource(path));
    }
}

