/*
 * Decompiled with CFR 0.152.
 */
package com.thorstenfischer.ui;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.Timer;

public class PulsePanel
extends JPanel
implements ActionListener {
    private static final long serialVersionUID = 1L;
    Color color = Color.WHITE;
    int millis = 20;
    int alpha_max = 200;
    int alpha_min = 100;
    int alpha_step = 10;
    int alpha = this.alpha_min;
    Timer timer = new Timer(this.millis, this);

    public PulsePanel() {
        this.initialize();
    }

    public PulsePanel(Color color) {
        this();
        this.color = new Color(color.getRed(), color.getGreen(), color.getBlue(), this.alpha);
    }

    public PulsePanel(Color color, int millis) {
        this(color);
        if (millis > 0) {
            this.timer = new Timer(millis, this);
        }
    }

    private void initialize() {
        this.setSize(300, 200);
        this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createBevelBorder(0), BorderFactory.createBevelBorder(1)));
        this.setOpaque(false);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.alpha += this.alpha_step;
        if (this.alpha > this.alpha_max) {
            this.alpha = this.alpha_max;
            this.alpha_step = -this.alpha_step;
        }
        if (this.alpha < this.alpha_min) {
            this.alpha = this.alpha_min;
            this.alpha_step = -this.alpha_step;
        }
        this.color = new Color(this.color.getRed(), this.color.getGreen(), this.color.getBlue(), this.alpha);
        this.repaint();
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2d = (Graphics2D)g;
        g2d.setPaint(this.color);
        g2d.fill(new Rectangle(this.getWidth(), this.getHeight()));
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.timer.start();
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        this.timer.stop();
    }
}

