/*
 * Decompiled with CFR 0.152.
 */
package com.thorstenfischer.ui;

import com.thorstenfischer.ui.HelpManager;
import com.thorstenfischer.ui.HelpTopic;
import com.thorstenfischer.ui.PulsePanel;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.GeneralPath;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class HelpPanel
extends JPanel {
    private static final int[][] P_OBEN = new int[][]{{5, 10}, {10, 1}, {15, 10}, {10, 1}, {10, 19}};
    private static final GeneralPath PFEIL_OBEN = HelpPanel.getPfeil(P_OBEN);
    private static final int[][] P_UNTEN = new int[][]{{5, 10}, {10, 19}, {15, 10}, {10, 19}, {10, 1}};
    private static final GeneralPath PFEIL_UNTEN = HelpPanel.getPfeil(P_UNTEN);
    private static final int[][] P_LINKS = new int[][]{{10, 15}, {1, 10}, {10, 5}, {1, 10}, {19, 10}};
    private static final GeneralPath PFEIL_LINKS = HelpPanel.getPfeil(P_LINKS);
    private static final int[][] P_RECHTS = new int[][]{{10, 15}, {19, 10}, {10, 5}, {1, 10}, {19, 10}};
    private static final GeneralPath PFEIL_RECHTS = HelpPanel.getPfeil(P_RECHTS);
    private static final int[][] P_RECHTS_OBEN = new int[][]{{8, 4}, {18, 2}, {16, 12}, {18, 2}, {2, 18}};
    private static final GeneralPath PFEIL_RECHTS_OBEN = HelpPanel.getPfeil(P_RECHTS_OBEN);
    private static final int[][] P_LINKS_OBEN = new int[][]{{4, 12}, {2, 2}, {12, 4}, {2, 2}, {18, 18}};
    private static final GeneralPath PFEIL_LINKS_OBEN = HelpPanel.getPfeil(P_LINKS_OBEN);
    private static final int[][] P_LINKS_UNTEN = new int[][]{{4, 8}, {2, 18}, {12, 16}, {2, 18}, {18, 2}};
    private static final GeneralPath PFEIL_LINKS_UNTEN = HelpPanel.getPfeil(P_LINKS_UNTEN);
    private static final int[][] P_RECHTS_UNTEN = new int[][]{{8, 16}, {18, 18}, {16, 8}, {18, 18}, {2, 2}};
    private static final GeneralPath PFEIL_RECHTS_UNTEN = HelpPanel.getPfeil(P_RECHTS_UNTEN);
    private static final long serialVersionUID = 1L;
    private JPanel pnlLinksOben = null;
    private JPanel pnlOben = null;
    private JPanel pnlRechtsOben = null;
    private JPanel pnlLinks = null;
    private JPanel pnlInhalt = null;
    private JPanel pnlRechts = null;
    private JPanel pnlLinksUnten = null;
    private JPanel pnlUnten = null;
    private JPanel pnlRechtsUnten = null;
    private HelpTopic ht = null;
    private List<JComponent> comp = null;
    private List<CompPulsePanel> pPnl = null;
    private JPanel pnlButtons = null;
    private JLabel lblInhalt = null;

    private static GeneralPath getPfeil(int[][] points) {
        GeneralPath ret = new GeneralPath(1, 5);
        ret.moveTo(points[0][0], points[0][1]);
        ret.lineTo(points[1][0], points[1][1]);
        ret.lineTo(points[2][0], points[2][1]);
        ret.moveTo(points[3][0], points[3][1]);
        ret.lineTo(points[4][0], points[4][1]);
        return ret;
    }

    private HelpPanel() {
    }

    public HelpPanel(HelpTopic ht, List<JComponent> comp) {
        this();
        this.ht = ht;
        this.comp = comp;
        this.initialize();
        this.myInitialize();
    }

    private void initialize() {
        GridBagConstraints cRechtsUnten = new GridBagConstraints();
        cRechtsUnten.gridx = 2;
        cRechtsUnten.anchor = 14;
        cRechtsUnten.gridy = 2;
        GridBagConstraints cUnten = new GridBagConstraints();
        cUnten.gridx = 1;
        cUnten.anchor = 15;
        cUnten.gridy = 2;
        GridBagConstraints cLinksUnten = new GridBagConstraints();
        cLinksUnten.gridx = 0;
        cLinksUnten.anchor = 16;
        cLinksUnten.gridy = 2;
        GridBagConstraints cRechts = new GridBagConstraints();
        cRechts.gridx = 2;
        cRechts.anchor = 13;
        cRechts.gridy = 1;
        GridBagConstraints cInhalt = new GridBagConstraints();
        cInhalt.gridx = 1;
        cInhalt.fill = 1;
        cInhalt.weightx = 1.0;
        cInhalt.weighty = 1.0;
        cInhalt.gridy = 1;
        GridBagConstraints cLinks = new GridBagConstraints();
        cLinks.gridx = 0;
        cLinks.anchor = 17;
        cLinks.gridy = 1;
        GridBagConstraints cRechtsOben = new GridBagConstraints();
        cRechtsOben.gridx = 2;
        cRechtsOben.anchor = 12;
        cRechtsOben.gridy = 0;
        GridBagConstraints cOben = new GridBagConstraints();
        cOben.gridx = 1;
        cOben.anchor = 11;
        cOben.gridy = 0;
        GridBagConstraints cLinksOben = new GridBagConstraints();
        cLinksOben.gridx = 0;
        cLinksOben.anchor = 18;
        cLinksOben.gridy = 0;
        this.setLayout(new GridBagLayout());
        this.add((Component)this.getPnlLinksOben(), cLinksOben);
        this.add((Component)this.getPnlOben(), cOben);
        this.add((Component)this.getPnlRechtsOben(), cRechtsOben);
        this.add((Component)this.getPnlLinks(), cLinks);
        this.add((Component)this.getPnlInhalt(), cInhalt);
        this.add((Component)this.getPnlRechts(), cRechts);
        this.add((Component)this.getPnlLinksUnten(), cLinksUnten);
        this.add((Component)this.getPnlUnten(), cUnten);
        this.add((Component)this.getPnlRechtsUnten(), cRechtsUnten);
        this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createBevelBorder(0), BorderFactory.createBevelBorder(1)));
        JDialog dlg = new JDialog();
        dlg.add(this);
        dlg.pack();
        Dimension d = this.getSize();
        dlg.dispose();
        this.setSize(d);
    }

    private void myInitialize() {
        this.setOpaque(false);
        this.pnlInhalt.setOpaque(false);
        if (this.comp != null) {
            this.pPnl = new ArrayList<CompPulsePanel>();
            for (JComponent c : this.comp) {
                this.pPnl.add(new CompPulsePanel(c));
            }
        }
        this.updateLocation();
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2d = (Graphics2D)g;
        g2d.setPaint(HelpManager.getColorBackground());
        g2d.fill(new Rectangle(this.getWidth(), this.getHeight()));
    }

    private JPanel getPnlLinksOben() {
        if (this.pnlLinksOben == null) {
            this.pnlLinksOben = new PfeilPanel(PFEIL_LINKS_OBEN);
        }
        return this.pnlLinksOben;
    }

    private JPanel getPnlOben() {
        if (this.pnlOben == null) {
            this.pnlOben = new PfeilPanel(PFEIL_OBEN);
        }
        return this.pnlOben;
    }

    private JPanel getPnlRechtsOben() {
        if (this.pnlRechtsOben == null) {
            this.pnlRechtsOben = new PfeilPanel(PFEIL_RECHTS_OBEN);
        }
        return this.pnlRechtsOben;
    }

    private JPanel getPnlLinks() {
        if (this.pnlLinks == null) {
            this.pnlLinks = new PfeilPanel(PFEIL_LINKS);
        }
        return this.pnlLinks;
    }

    private JPanel getPnlRechts() {
        if (this.pnlRechts == null) {
            this.pnlRechts = new PfeilPanel(PFEIL_RECHTS);
        }
        return this.pnlRechts;
    }

    private JPanel getPnlLinksUnten() {
        if (this.pnlLinksUnten == null) {
            this.pnlLinksUnten = new PfeilPanel(PFEIL_LINKS_UNTEN);
        }
        return this.pnlLinksUnten;
    }

    private JPanel getPnlUnten() {
        if (this.pnlUnten == null) {
            this.pnlUnten = new PfeilPanel(PFEIL_UNTEN);
        }
        return this.pnlUnten;
    }

    private JPanel getPnlRechtsUnten() {
        if (this.pnlRechtsUnten == null) {
            this.pnlRechtsUnten = new PfeilPanel(PFEIL_RECHTS_UNTEN);
        }
        return this.pnlRechtsUnten;
    }

    private JPanel getPnlInhalt() {
        if (this.pnlInhalt == null) {
            this.lblInhalt = new JLabel();
            this.lblInhalt.setText(this.ht.getText());
            this.lblInhalt.setFont(HelpManager.getFont());
            this.lblInhalt.setForeground(HelpManager.getColorFont());
            this.pnlInhalt = new JPanel();
            this.pnlInhalt.setLayout(new BorderLayout());
            this.pnlInhalt.add((Component)this.getPnlButtons(), "South");
            this.pnlInhalt.add((Component)this.lblInhalt, "Center");
        }
        return this.pnlInhalt;
    }

    public void updateLocation() {
        if (this.comp != null) {
            JComponent c = this.comp.get(0);
            int w = this.getWidth();
            int h = this.getHeight();
            int cx = (int)c.getLocation().getX();
            int cy = (int)c.getLocation().getY();
            int cw = c.getWidth();
            int ch = c.getHeight();
            int x = cx;
            int y = cy;
            switch (this.ht.getPositionComp()) {
                case FIRST_LINE_START: {
                    break;
                }
                case PAGE_START: {
                    x += cw / 2;
                    break;
                }
                case FIRST_LINE_END: {
                    x += cw;
                    break;
                }
                case LINE_START: {
                    y += ch / 2;
                    break;
                }
                case CENTER: {
                    x += cw / 2;
                    y += ch / 2;
                    break;
                }
                case LINE_END: {
                    x += cw;
                    y += ch / 2;
                    break;
                }
                case LAST_LINE_START: {
                    y += ch;
                    break;
                }
                case PAGE_END: {
                    x += cw / 2;
                    y += ch;
                    break;
                }
                case LAST_LINE_END: {
                    x += cw;
                    y += ch;
                }
            }
            switch (this.ht.getPositionHelp()) {
                case FIRST_LINE_START: {
                    break;
                }
                case PAGE_START: {
                    x -= w / 2;
                    break;
                }
                case FIRST_LINE_END: {
                    x -= w;
                    break;
                }
                case LINE_START: {
                    y -= h / 2;
                    break;
                }
                case CENTER: {
                    x -= w / 2;
                    y -= h / 2;
                    break;
                }
                case LINE_END: {
                    x -= w;
                    y -= h / 2;
                    break;
                }
                case LAST_LINE_START: {
                    y -= h;
                    break;
                }
                case PAGE_END: {
                    x -= w / 2;
                    y -= h;
                    break;
                }
                case LAST_LINE_END: {
                    x -= w;
                    y -= h;
                }
            }
            this.setLocation(new Point(x, y));
            for (CompPulsePanel p : this.pPnl) {
                p.updatePosition();
            }
        }
    }

    private JPanel getPnlButtons() {
        if (this.pnlButtons == null) {
            this.pnlButtons = new JPanel();
            this.pnlButtons.setLayout(new GridBagLayout());
        }
        return this.pnlButtons;
    }

    public List<CompPulsePanel> getPulsePanel() {
        return this.pPnl;
    }

    class CompPulsePanel
    extends PulsePanel {
        JComponent c;

        private CompPulsePanel() {
            this.c = null;
        }

        public CompPulsePanel(JComponent c) {
            super(HelpManager.getColorBackground());
            this.c = null;
            this.c = c;
            this.updatePosition();
        }

        public void updatePosition() {
            this.setBounds(this.c.getBounds());
        }
    }

    class PfeilPanel
    extends JPanel {
        GeneralPath pfeil = null;
        final BasicStroke stroke = new BasicStroke(3.0f, 1, 0);

        public PfeilPanel() {
            Dimension d = new Dimension(20, 20);
            this.setPreferredSize(d);
            this.setMaximumSize(d);
            this.setMinimumSize(d);
            this.setSize(d);
            this.setOpaque(false);
        }

        public PfeilPanel(GeneralPath pfeil) {
            this();
            this.pfeil = pfeil;
        }

        @Override
        protected void paintComponent(Graphics g) {
            super.paintComponent(g);
            if (this.pfeil == null) {
                return;
            }
            Graphics2D g2d = (Graphics2D)g;
            g2d.setColor(HelpManager.colorArrow);
            g2d.setStroke(this.stroke);
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2d.draw(this.pfeil);
        }
    }
}

