/*
 * Decompiled with CFR 0.152.
 */
package com.thorstenfischer.ui;

import com.thorstenfischer.ui.HelpPanel;
import com.thorstenfischer.ui.HelpTopic;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLayeredPane;

public class HelpManager {
    private static Font font = new Font("Serif", 0, 18);
    public static Color colorArrow = Color.BLUE;
    private static int colorBackgroundAlpha = 204;
    public static Color colorBackground = new Color(255, 255, 255, colorBackgroundAlpha);
    private static Color colorFont = Color.BLACK;
    private JFrame jFrame = null;
    private final ResizeListener rl = new ResizeListener();
    private final Map<HelpTopic, HelpPanel> helpPanels = new HashMap<HelpTopic, HelpPanel>();
    private boolean visible = false;

    public static Font getFont() {
        return font;
    }

    public static void setFont(Font font) {
        if (font == null) {
            return;
        }
        HelpManager.font = font;
    }

    public static Color getColorArrow() {
        return colorArrow;
    }

    public static void setColorArrow(Color colorArrow) {
        if (colorArrow == null) {
            return;
        }
        HelpManager.colorArrow = colorArrow;
    }

    public static int getColorBackgroundAlpha() {
        return colorBackgroundAlpha;
    }

    public static void setColorBackgroundAlpha(int colorBackgroundAlpha) {
        if (colorBackgroundAlpha < 0 || colorBackgroundAlpha > 255) {
            return;
        }
        HelpManager.colorBackgroundAlpha = colorBackgroundAlpha;
        colorBackground = new Color(colorBackground.getRed(), colorBackground.getGreen(), colorBackground.getBlue(), colorBackgroundAlpha);
    }

    public static Color getColorBackground() {
        return colorBackground;
    }

    public static void setColorBackground(Color colorBackground) {
        if (colorBackground == null) {
            return;
        }
        HelpManager.colorBackground = colorBackground;
        colorBackgroundAlpha = colorBackground.getAlpha();
    }

    public static Color getColorFont() {
        return colorFont;
    }

    public static void setColorFont(Color colorFont) {
        if (colorFont == null) {
            return;
        }
        HelpManager.colorFont = colorFont;
    }

    private HelpManager() {
    }

    private HelpManager(JFrame jFrame) {
        this.jFrame = jFrame;
    }

    private ResizeListener getResizeListener() {
        return this.rl;
    }

    public static void register(JFrame jFrame) {
        if (!(jFrame instanceof HelpedFrame)) {
            throw new IllegalArgumentException("jFrame hat nicht HelpedFrame implementiert.");
        }
        HelpManager hp = new HelpManager(jFrame);
        jFrame.addComponentListener(hp.getResizeListener());
        ((HelpedFrame)((Object)jFrame)).setHelpManager(hp);
    }

    private void updateHelpLocation() {
        if (!this.visible) {
            return;
        }
        for (HelpPanel hp : this.helpPanels.values()) {
            if (!hp.isVisible()) continue;
            hp.updateLocation();
        }
    }

    public void display(HelpTopic ht, JComponent ... c) {
        HelpPanel hp = null;
        if (this.visible) {
            return;
        }
        if (c != null) {
            ArrayList<JComponent> comp = null;
            int i = 0;
            while (i < c.length) {
                if (c[i] != null) {
                    if (comp == null) {
                        comp = new ArrayList<JComponent>();
                    }
                    comp.add(c[i]);
                }
                ++i;
            }
            hp = this.getHelpPanel(ht, comp);
            List<HelpPanel.CompPulsePanel> pPnl = hp.getPulsePanel();
            if (pPnl != null) {
                for (HelpPanel.CompPulsePanel p : pPnl) {
                    this.jFrame.getLayeredPane().add((Component)p, JLayeredPane.POPUP_LAYER);
                }
            }
            this.jFrame.getLayeredPane().add((Component)hp, JLayeredPane.POPUP_LAYER);
            this.visible = true;
        }
    }

    private HelpPanel getHelpPanel(HelpTopic ht, List<JComponent> comp) {
        HelpPanel ret = this.helpPanels.get(ht);
        if (ret == null) {
            ret = new HelpPanel(ht, comp);
            this.helpPanels.put(ht, ret);
        }
        return ret;
    }

    public static interface HelpedFrame {
        public void setHelpManager(HelpManager var1);
    }

    class ResizeListener
    extends ComponentAdapter {
        ResizeListener() {
        }

        @Override
        public void componentResized(ComponentEvent e) {
            HelpManager.this.updateHelpLocation();
        }
    }
}

