/*
 * Decompiled with CFR 0.152.
 */
package com.thorstenfischer.sappasswortwizard.ui;

import com.thorstenfischer.sappasswortwizard.PasswortDaten;
import com.thorstenfischer.sappasswortwizard.SapPasswortWizard;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.ToolTipManager;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;

public class MainFrame
extends JFrame {
    private PasswortDaten data;
    private static final long serialVersionUID = 1L;
    private JPanel jContentPane = null;
    private JPanel pnlMain = null;
    private JTextField txtMandant = null;
    private JLabel lblMandant = null;
    public JPasswordField txtPwdAlt = null;
    private JLabel lblPwdAlt = null;
    private JPasswordField txtPwdNeu = null;
    private JLabel lblPwdNeu = null;
    private JPanel pnlButtons = null;
    private JButton cmdGo = null;
    private JButton cmdExit = null;
    private JLabel lblUser = null;
    private JTextField txtUser = null;
    private JPanel pnlSouth = null;
    private JLabel lblStatusbar = null;

    public MainFrame() {
        this.initialize();
    }

    public MainFrame(PasswortDaten data) {
        this();
        this.data = data;
        this.txtMandant.setText(data.getMandant());
        this.txtUser.setText(data.getUser());
    }

    private void initialize() {
        this.setSize(493, 349);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                SapPasswortWizard.end();
            }
        });
        this.setResizable(false);
        this.setContentPane(this.getJContentPane());
        this.setTitle("SAP Pa\u00dfwort Wizard");
        this.setVisible(false);
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new BorderLayout());
            this.jContentPane.add((Component)this.getPnlMain(), "Center");
            this.jContentPane.add((Component)this.getPnlSouth(), "South");
        }
        return this.jContentPane;
    }

    private JPanel getPnlMain() {
        if (this.pnlMain == null) {
            this.lblUser = new JLabel();
            this.lblUser.setBounds(new Rectangle(54, 42, 95, 16));
            this.lblUser.setText("Benutzer:");
            this.lblPwdNeu = new JLabel();
            this.lblPwdNeu.setText("Neues Pa\u00dfwort:");
            this.lblPwdNeu.setBounds(new Rectangle(54, 172, 90, 20));
            this.lblPwdAlt = new JLabel();
            this.lblPwdAlt.setText("Altes Pa\u00dfwort:");
            this.lblPwdAlt.setBounds(new Rectangle(54, 127, 90, 20));
            this.lblMandant = new JLabel();
            this.lblMandant.setText("Mandant:");
            this.lblMandant.setBounds(new Rectangle(54, 86, 52, 16));
            this.pnlMain = new JPanel();
            this.pnlMain.setLayout(null);
            this.pnlMain.add((Component)this.lblUser, null);
            this.pnlMain.add((Component)this.getTxtUser(), null);
            this.pnlMain.add((Component)this.lblMandant, null);
            this.pnlMain.add((Component)this.getTxtMandant(), null);
            this.pnlMain.add((Component)this.lblPwdAlt, null);
            this.pnlMain.add((Component)this.getTxtPwdAlt(), null);
            this.pnlMain.add((Component)this.lblPwdNeu, null);
            this.pnlMain.add((Component)this.getTxtPwdNeu(), null);
        }
        return this.pnlMain;
    }

    private JTextField getTxtMandant() {
        if (this.txtMandant == null) {
            this.txtMandant = new JTextField(){

                @Override
                protected Document createDefaultModel() {
                    return new MandantDocument();
                }

                class MandantDocument
                extends PlainDocument {
                    MandantDocument() {
                    }

                    @Override
                    public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
                        if (str == null) {
                            return;
                        }
                        char[] c = str.toCharArray();
                        int i = 0;
                        while (i < c.length) {
                            c[i] = c[i] >= '1' && c[i] <= '9' || c[i] == '0' ? c[i] : 48;
                            ++i;
                        }
                        str = new String(c);
                        if (this.getLength() + str.length() <= 3) {
                            super.insertString(offs, str, a);
                        }
                    }
                }
            };
            this.txtMandant.setBounds(new Rectangle(160, 85, 116, 20));
        }
        return this.txtMandant;
    }

    private JPasswordField getTxtPwdAlt() {
        if (this.txtPwdAlt == null) {
            this.txtPwdAlt = new SAPPasswortField();
            this.txtPwdAlt.setBounds(new Rectangle(160, 127, 116, 20));
            this.txtPwdAlt.setToolTipText("Nicht erlaubte Zeichen: \u00e4\u00f6\u00fc\u00c4\u00d6\u00dc\u00a7?\u00b4`^\u00b0/|");
        }
        return this.txtPwdAlt;
    }

    private JPasswordField getTxtPwdNeu() {
        if (this.txtPwdNeu == null) {
            this.txtPwdNeu = new SAPPasswortField();
            this.txtPwdNeu.setBounds(new Rectangle(160, 174, 116, 20));
            this.txtPwdNeu.setToolTipText("Nicht erlaubte Zeichen: \u00e4\u00f6\u00fc\u00c4\u00d6\u00dc\u00a7?\u00b4`^\u00b0/|");
        }
        return this.txtPwdNeu;
    }

    private JPanel getPnlButtons() {
        if (this.pnlButtons == null) {
            this.pnlButtons = new JPanel();
            this.pnlButtons.setLayout(new FlowLayout());
            this.pnlButtons.add((Component)this.getCmdGo(), null);
            this.pnlButtons.add((Component)this.getCmdExit(), null);
        }
        return this.pnlButtons;
    }

    private JButton getCmdGo() {
        if (this.cmdGo == null) {
            this.cmdGo = new JButton();
            this.cmdGo.setText("Pa\u00dfwort \u00e4ndern");
            this.cmdGo.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MainFrame.this.cmdGo_actionPerformed(e);
                }
            });
        }
        return this.cmdGo;
    }

    protected void cmdGo_actionPerformed(ActionEvent e) {
        System.out.println("cmdGo_actionPerformed()");
        if (this.txtMandant.getText().equals("")) {
            this.displayStatus("Bitte Mandanten angeben.");
            this.txtMandant.requestFocusInWindow();
            return;
        }
        this.data.setMandant(this.txtMandant.getText());
        if (this.txtUser.getText().equals("")) {
            this.displayStatus("Bitte Benutzer angeben.");
            this.txtUser.requestFocusInWindow();
            return;
        }
        this.data.setUser(this.txtUser.getText());
        this.data.setAltesPw(this.txtPwdAlt.getPassword());
        if (this.data.getAltesPw().equals("")) {
            this.displayStatus("Bitte das alte Pa\u00dfwort angeben.");
            this.txtPwdAlt.requestFocusInWindow();
            return;
        }
        this.data.setNeuesPw(this.txtPwdNeu.getPassword());
        if (this.data.getNeuesPw().equals("")) {
            this.displayStatus("Bitte das neue Pa\u00dfwort angeben.");
            this.txtPwdNeu.requestFocusInWindow();
            return;
        }
        if (SapPasswortWizard.changePw() == 1) {
            this.displayStatus("Der Wizard l\u00e4uft noch!");
        } else {
            this.displayStatus("Wizard gestartet.");
        }
    }

    private JButton getCmdExit() {
        if (this.cmdExit == null) {
            this.cmdExit = new JButton();
            this.cmdExit.setText("Ende");
            this.cmdExit.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MainFrame.this.cmdExit_actionPerformed(e);
                }
            });
        }
        return this.cmdExit;
    }

    protected void cmdExit_actionPerformed(ActionEvent e) {
        SapPasswortWizard.end();
    }

    private JTextField getTxtUser() {
        if (this.txtUser == null) {
            this.txtUser = new JTextField();
            this.txtUser.setBounds(new Rectangle(160, 42, 116, 20));
        }
        return this.txtUser;
    }

    private JPanel getPnlSouth() {
        if (this.pnlSouth == null) {
            this.lblStatusbar = new JLabel();
            this.lblStatusbar.setText("  ");
            this.pnlSouth = new JPanel();
            this.pnlSouth.setLayout(new BorderLayout());
            this.pnlSouth.add((Component)this.getPnlButtons(), "Center");
            this.pnlSouth.add((Component)this.lblStatusbar, "South");
        }
        return this.pnlSouth;
    }

    public void setFocus() {
        this.txtPwdAlt.requestFocusInWindow();
    }

    public void displayStatus(String status) {
        this.lblStatusbar.setText(status);
    }

    public PasswortDaten getData() {
        return this.data;
    }

    public static void noTDatFile(String file) {
        String[] msg = new String[]{"Die Datei", "", "existiert nicht.", "Bitte die Datei erstellen oder beim Aufruf von", "java -jar SapPasswortWizard.jar <Tastenliste.txt>", "eine Datei angeben."};
        msg[1] = file;
        JOptionPane.showMessageDialog(null, msg, "Bitte Datei f\u00fcr die Tastenliste angeben.", 0);
    }

    public static void displayParseError(String e) {
        String[] msg = new String[]{"In der Tastenlisten-Datei befindet sich folgender Fehler:", ""};
        msg[1] = e;
        JOptionPane.showMessageDialog(null, msg, "Fehler in der Tastenliste-Datei.", 0);
    }

    private final class SAPPasswortField
    extends JPasswordField {
        public static final String UNERLAUBTE = "\u00e4\u00f6\u00fc\u00c4\u00d6\u00dc\u00a7?\u00b4`^\u00b0/|";

        protected SAPPasswortField() {
            ToolTipManager.sharedInstance().setInitialDelay(0);
        }

        @Override
        protected Document createDefaultModel() {
            return new MandantDocument();
        }

        protected void showTTT() {
            ToolTipManager.sharedInstance().mouseMoved(new MouseEvent(this, 0, 0L, 0, 0, 0, 0, false));
        }

        class MandantDocument
        extends PlainDocument {
            MandantDocument() {
            }

            @Override
            public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
                if (str == null) {
                    return;
                }
                if (!str.matches(".*[\u00e4\u00f6\u00fc\u00c4\u00d6\u00dc\u00a7?\u00b4`^\u00b0/|].*")) {
                    super.insertString(offs, str, a);
                } else {
                    SAPPasswortField.this.showTTT();
                }
            }
        }
    }
}

