/*
 * Decompiled with CFR 0.152.
 */
package com.thorstenfischer.sappasswortwizard;

import com.thorstenfischer.sappasswortwizard.Abspulliste;
import com.thorstenfischer.sappasswortwizard.PasswortDaten;
import com.thorstenfischer.sappasswortwizard.SapPasswortRoboter;
import com.thorstenfischer.sappasswortwizard.ui.MainFrame;
import com.thorstenfischer.ui.Util;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.SwingUtilities;

public class SapPasswortWizard {
    private static MainFrame frame = null;
    private static SapPasswortRoboter robot;
    private static Abspulliste aListe;
    private static final String TDAT_FNAM = "Tastenliste.txt";

    public static void main(String[] args) {
        File tDat = null;
        tDat = args == null || args.length != 1 ? new File(String.valueOf(System.getProperty("user.dir")) + File.separator + TDAT_FNAM) : new File(args[0]);
        if (!tDat.exists()) {
            String fNam = "Fehler beim Ermitteln des Pfades f\u00fcr die Datei.";
            try {
                fNam = tDat.getCanonicalPath();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            MainFrame.noTDatFile(fNam);
            SapPasswortWizard.end();
        }
        SapPasswortWizard.initAbspulliste(tDat);
        SwingUtilities.invokeLater(new SapPasswortWizard().new SPWRunnable());
    }

    public static void end() {
        if (frame != null) {
            frame.setVisible(false);
            frame.dispose();
            frame = null;
        }
        System.gc();
        System.exit(0);
    }

    private static List<String> importTastenliste(File dat) {
        ArrayList<String> ret = new ArrayList<String>();
        BufferedReader bis = null;
        try {
            bis = new BufferedReader(new FileReader(dat));
        }
        catch (FileNotFoundException e) {
            System.out.println("Datei: " + dat + " nicht gefunden.");
            System.exit(1);
        }
        String s = null;
        try {
            while ((s = bis.readLine()) != null) {
                ret.add(s);
            }
        }
        catch (IOException e) {
            System.out.println("Fehler beim Einlesen der Datei: " + dat);
            System.exit(1);
        }
        return ret;
    }

    public static int changePw() {
        PasswortDaten data = frame.getData();
        if (robot != null && !robot.isDone()) {
            return 1;
        }
        try {
            aListe.setData(data);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        robot = new SapPasswortRoboter(aListe, frame);
        robot.execute();
        return 0;
    }

    public static void initAbspulliste(File file) {
        List<String> tastenListe = null;
        tastenListe = SapPasswortWizard.importTastenliste(file);
        try {
            aListe = new Abspulliste(new PasswortDaten(), tastenListe);
        }
        catch (ParseException e) {
            e.printStackTrace();
            MainFrame.displayParseError(e.getMessage());
            SapPasswortWizard.end();
        }
    }

    class SPWRunnable
    implements Runnable {
        SPWRunnable() {
        }

        @Override
        public void run() {
            frame = new MainFrame(new PasswortDaten());
            Util.center(frame);
            frame.setVisible(true);
            frame.setFocus();
        }
    }
}

