/*
 * Decompiled with CFR 0.152.
 */
package com.thorstenfischer.sappasswortwizard;

import com.thorstenfischer.sappasswortwizard.PasswortDaten;
import com.thorstenfischer.sappasswortwizard.RobotEvent;
import java.io.PrintStream;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;

public class Abspulliste {
    private List<RobotEvent> kEList = null;
    private List<String> tokens;
    private PasswortDaten data = null;

    private Abspulliste() {
    }

    public Abspulliste(PasswortDaten data, List<String> tastenListe) throws ParseException {
        this();
        this.data = data;
        this.tokens = tastenListe;
        this.parse();
    }

    private void parse() throws ParseException {
        if (this.tokens == null) {
            throw new NullPointerException("Leere Tastenliste in Abspulliste.parse()");
        }
        this.kEList = new ArrayList<RobotEvent>();
        for (String s : this.tokens) {
            int ms;
            if (s.matches(".*>\\s+\\+.*")) {
                throw new ParseException("Falsche Syntax: zwischen > und + keine Leerzeichen erlaubt: \"" + s + "\"", 0);
            }
            if (s.matches(".*\\+\\s+<.*")) {
                throw new ParseException("Falsche Syntax: zwischen + und < keine Leerzeichen erlaubt: \"" + s + "\"", 0);
            }
            if (s.startsWith("#")) continue;
            if (s.matches("<WAIT>\\d{2,4}")) {
                ms = Integer.parseInt(s.substring(6, s.length()));
                this.addWait(ms);
                continue;
            }
            if (s.matches("<DELAY>\\d{1,3}")) {
                ms = Integer.parseInt(s.substring(7, s.length()));
                this.addDelay(ms);
                continue;
            }
            if (s.contains(">+")) {
                String[] tags = s.split("\\+");
                int i = 0;
                while (i <= tags.length - 2) {
                    try {
                        this.addModifier(tags[i], RobotEvent.Action.PRESS);
                    }
                    catch (ParseException e) {
                        throw new ParseException(String.valueOf(e.getMessage()) + "\n" + "Ung\u00fcltiger Modifier in \"" + s + "\"", 0);
                    }
                    ++i;
                }
                String tag = tags[tags.length - 1];
                try {
                    this.addTag(tag);
                }
                catch (ParseException e) {
                    try {
                        this.addSimpleTag(tag);
                    }
                    catch (ParseException e1) {
                        throw new ParseException(String.valueOf(e1.getMessage()) + "\n" + "Ung\u00fcltiges Tag in \"" + s + "\"", 0);
                    }
                }
                int i2 = tags.length - 2;
                while (i2 >= 0) {
                    try {
                        this.addModifier(tags[i2], RobotEvent.Action.RELEASE);
                    }
                    catch (ParseException e) {
                        throw new ParseException(String.valueOf(e.getMessage()) + "\n" + "Ung\u00fcltiger Modifier in \"" + s + "\"", 0);
                    }
                    --i2;
                }
                continue;
            }
            if (s.matches(".+<\\w+>")) {
                this.addString(s.substring(0, s.indexOf("<")));
                this.addTag(s.substring(s.indexOf("<")));
                continue;
            }
            if (s.contains("<")) {
                try {
                    this.addTag(s);
                    continue;
                }
                catch (ParseException e) {
                    throw new ParseException(String.valueOf(e.getMessage()) + "\n" + "Ung\u00fcltiges Tag in \"" + s + "\"", 0);
                }
            }
            if (s.matches("\\s*")) continue;
            this.addString(s);
        }
    }

    private void addSimpleTag(String tag) throws ParseException {
        String tagName = this.getTagName(tag);
        if (!tagName.matches("[a-zA-Z0-9]")) {
            throw new ParseException("Nur einzelne Buchstaben oder Ziffern erlaubt\"" + tagName + "\"", 0);
        }
        char c = Character.toUpperCase(tagName.charAt(0));
        if (c >= 'A' && c <= 'Z' || c >= '1' && c <= '9' || c == '0') {
            this.addStroke(c);
        }
    }

    private void addWait(int ms) {
        this.kEList.add(new RobotEvent(RobotEvent.Action.WAIT, ms));
    }

    private void addDelay(int ms) {
        this.kEList.add(new RobotEvent(RobotEvent.Action.DELAY, ms));
    }

    private void addModifier(String tag, RobotEvent.Action robotEvent) throws ParseException {
        boolean k = false;
        String tagName = this.getTagName(tag);
        if (tagName.equals("ALT")) {
            k = true;
            this.kEList.add(new RobotEvent(robotEvent, 18));
        }
        if (tagName.equals("ALT_GRAPH")) {
            k = true;
            this.kEList.add(new RobotEvent(robotEvent, 65406));
        }
        if (tagName.equals("ALTGR")) {
            k = true;
            this.kEList.add(new RobotEvent(robotEvent, 65406));
        }
        if (tagName.equals("SHIFT")) {
            k = true;
            this.kEList.add(new RobotEvent(robotEvent, 16));
        }
        if (tagName.equals("UMSCHALT")) {
            k = true;
            this.kEList.add(new RobotEvent(robotEvent, 16));
        }
        if (tagName.equals("CONTROL")) {
            k = true;
            this.kEList.add(new RobotEvent(robotEvent, 17));
        }
        if (tagName.equals("CTRL")) {
            k = true;
            this.kEList.add(new RobotEvent(robotEvent, 17));
        }
        if (tagName.equals("STRG")) {
            k = true;
            this.kEList.add(new RobotEvent(robotEvent, 17));
        }
        if (!k) {
            throw new ParseException("Unbekanntes Tag: " + tagName, 0);
        }
    }

    private void addTag(String s) throws ParseException {
        String tagInhalt = this.getTagName(s);
        boolean k = false;
        if (tagInhalt.equals("F1")) {
            this.addStroke(112);
            k = true;
        }
        if (tagInhalt.equals("F2")) {
            this.addStroke(113);
            k = true;
        }
        if (tagInhalt.equals("F3")) {
            this.addStroke(114);
            k = true;
        }
        if (tagInhalt.equals("F4")) {
            this.addStroke(115);
            k = true;
        }
        if (tagInhalt.equals("F5")) {
            this.addStroke(116);
            k = true;
        }
        if (tagInhalt.equals("F6")) {
            this.addStroke(117);
            k = true;
        }
        if (tagInhalt.equals("F7")) {
            this.addStroke(118);
            k = true;
        }
        if (tagInhalt.equals("F8")) {
            this.addStroke(119);
            k = true;
        }
        if (tagInhalt.equals("F9")) {
            this.addStroke(120);
            k = true;
        }
        if (tagInhalt.equals("F10")) {
            this.addStroke(121);
            k = true;
        }
        if (tagInhalt.equals("F11")) {
            this.addStroke(122);
            k = true;
        }
        if (tagInhalt.equals("F12")) {
            this.addStroke(123);
            k = true;
        }
        if (tagInhalt.equals("F13")) {
            this.addStroke(61440);
            k = true;
        }
        if (tagInhalt.equals("F14")) {
            this.addStroke(61441);
            k = true;
        }
        if (tagInhalt.equals("F15")) {
            this.addStroke(61442);
            k = true;
        }
        if (tagInhalt.equals("F16")) {
            this.addStroke(61443);
            k = true;
        }
        if (tagInhalt.equals("F17")) {
            this.addStroke(61444);
            k = true;
        }
        if (tagInhalt.equals("F18")) {
            this.addStroke(61445);
            k = true;
        }
        if (tagInhalt.equals("F19")) {
            this.addStroke(61446);
            k = true;
        }
        if (tagInhalt.equals("F20")) {
            this.addStroke(61447);
            k = true;
        }
        if (tagInhalt.equals("TAB")) {
            this.addStroke(9);
            k = true;
        }
        if (tagInhalt.equals("CANCEL")) {
            this.addStroke(3);
            k = true;
        }
        if (tagInhalt.equals("ENTER")) {
            this.addStroke(10);
            k = true;
        }
        if (tagInhalt.equals("ESCAPE")) {
            this.addStroke(27);
            k = true;
        }
        if (tagInhalt.equals("ESC")) {
            this.addStroke(27);
            k = true;
        }
        if (tagInhalt.equals("SPACE")) {
            this.addStroke(32);
            k = true;
        }
        if (tagInhalt.equals("DEL")) {
            this.addStroke(127);
            k = true;
        }
        if (tagInhalt.equals("DELETE")) {
            this.addStroke(127);
            k = true;
        }
        if (tagInhalt.equals("ENTF")) {
            this.addStroke(127);
            k = true;
        }
        if (tagInhalt.equals("UP")) {
            this.addStroke(38);
            k = true;
        }
        if (tagInhalt.equals("DOWN")) {
            this.addStroke(40);
            k = true;
        }
        if (tagInhalt.equals("LEFT")) {
            this.addStroke(37);
            k = true;
        }
        if (tagInhalt.equals("RIGHT")) {
            this.addStroke(39);
            k = true;
        }
        if (tagInhalt.equals("PAGE_UP")) {
            this.addStroke(33);
            k = true;
        }
        if (tagInhalt.equals("PAGE_DOWN")) {
            this.addStroke(34);
            k = true;
        }
        if (tagInhalt.equals("HOME")) {
            this.addStroke(36);
            k = true;
        }
        if (tagInhalt.equals("END")) {
            this.addStroke(35);
            k = true;
        }
        if (tagInhalt.equals("ALTESPW")) {
            this.addString(this.data.getAltesPw());
            k = true;
        }
        if (tagInhalt.equals("NEUESPW")) {
            this.addString(this.data.getNeuesPw());
            k = true;
        }
        if (tagInhalt.equals("BENUTZER")) {
            this.addString(this.data.getUser());
            k = true;
        }
        if (tagInhalt.equals("MANDANT")) {
            this.addString(this.data.getMandant());
            k = true;
        }
        if (!k) {
            throw new ParseException("Unbekanntes Tag: " + tagInhalt, 0);
        }
    }

    private String getTagName(String s) throws ParseException {
        if (!s.startsWith("<") || !s.endsWith(">")) {
            throw new ParseException("Tag beginnt nicht mit < und endet nicht mit >", 0);
        }
        String ret = s.substring(1, s.length() - 1).trim().toUpperCase();
        return ret;
    }

    private void addStroke(int kE) {
        this.kEList.add(new RobotEvent(RobotEvent.Action.PRESS, kE));
        this.kEList.add(new RobotEvent(RobotEvent.Action.RELEASE, kE));
    }

    private void addString(String s) throws ParseException {
        boolean isUpper = false;
        int i = 0;
        while (i < s.length()) {
            Character c = Character.valueOf(s.charAt(i));
            isUpper = Character.isUpperCase(c.charValue());
            if ((c = Character.valueOf(Character.toUpperCase(c.charValue()))).charValue() >= 'A' && c.charValue() <= 'Z') {
                if (isUpper) {
                    this.kEList.add(new RobotEvent(RobotEvent.Action.PRESS, 16));
                }
                this.addStroke(c.charValue());
                if (isUpper) {
                    this.kEList.add(new RobotEvent(RobotEvent.Action.RELEASE, 16));
                }
            } else {
                switch (c.charValue()) {
                    case '1': {
                        this.addStroke(49);
                        break;
                    }
                    case '2': {
                        this.addStroke(50);
                        break;
                    }
                    case '3': {
                        this.addStroke(51);
                        break;
                    }
                    case '4': {
                        this.addStroke(52);
                        break;
                    }
                    case '5': {
                        this.addStroke(53);
                        break;
                    }
                    case '6': {
                        this.addStroke(54);
                        break;
                    }
                    case '7': {
                        this.addStroke(55);
                        break;
                    }
                    case '8': {
                        this.addStroke(56);
                        break;
                    }
                    case '9': {
                        this.addStroke(57);
                        break;
                    }
                    case '0': {
                        this.addStroke(48);
                        break;
                    }
                    case '.': {
                        this.addStroke(46);
                        break;
                    }
                    case ':': {
                        this.addStroke(513);
                        break;
                    }
                    case ',': {
                        this.addStroke(44);
                        break;
                    }
                    case ';': {
                        this.addStroke(59);
                        break;
                    }
                    case '-': {
                        this.addStroke(45);
                        break;
                    }
                    case '_': {
                        this.addStroke(523);
                        break;
                    }
                    case '*': {
                        this.addStroke(151);
                        break;
                    }
                    case '+': {
                        this.addStroke(521);
                        break;
                    }
                    case '#': {
                        this.addStroke(520);
                        break;
                    }
                    case '!': {
                        this.addStroke(517);
                        break;
                    }
                    case '\"': {
                        this.addStroke(152);
                        break;
                    }
                    case '$': {
                        this.addStroke(515);
                        break;
                    }
                    case '&': {
                        this.addStroke(150);
                        break;
                    }
                    case '/': {
                        this.addStroke(47);
                        break;
                    }
                    case '(': {
                        this.addStroke(519);
                        break;
                    }
                    case ')': {
                        this.addStroke(522);
                        break;
                    }
                    case '=': {
                        this.addStroke(61);
                        break;
                    }
                    case ' ': {
                        this.addStroke(32);
                        break;
                    }
                    case '<': {
                        this.addStroke(153);
                        break;
                    }
                    case '>': {
                        this.addStroke(160);
                        break;
                    }
                    default: {
                        throw new ParseException("Unbekanntes Zeichen in " + s + ": \"" + s.charAt(i) + "\"", 0);
                    }
                }
            }
            ++i;
        }
    }

    public List<RobotEvent> getAList() throws IllegalStateException {
        if (this.kEList == null) {
            throw new IllegalStateException("Aufruf von geAList vor setData oder setTastenliste");
        }
        return this.kEList;
    }

    public void print(PrintStream out) {
        for (RobotEvent re : this.kEList) {
            re.print(out);
        }
    }

    public void setData(PasswortDaten data) throws ParseException {
        this.data = data;
        this.parse();
    }
}

