package socketVerbindung;

import java.io.*;
import java.net.*;
import httpServer.*;


/** 
 *  Diese Klasse stellt eine TCP/IP-Verbindung dar.
 *
 *  @author  Thorsten Fischer
 *  @version 1.0, 30.05.2000
 */
public class Verbindung {
  
  /** Der Socket, der die TCP/IP-Verbindung darstellt */
  private Socket clientSocket = null;
  
  /** Der Eingabestrom vom Client */
  private BufferedReader in  = null;       
  
  /** Der Ausgabestrom zum Client */
  private DataOutputStream out = null;
  
  /**
   *  Eine Erzeugung einer Verbindung ist nur ber 
   *  das Akzeptieren einer eingehenden Socket-Verbindung
   *  mglich
   */
  private Verbindung() {}
  
  /**
   *  Erzeugt eine Verbindung, indem versucht wird, 
   *  einen eingehenden TCP/IP-Verbindungswunsch zu
   *  akzeptieren
   *  @param serverSocket Der Verbindungswunsch
   */
  public Verbindung( ServerSocket serverSocket ) throws IOException {
    clientSocket = serverSocket.accept();
    in           = new BufferedReader(				
                   new InputStreamReader(				
                         clientSocket.getInputStream()
                   ));        
    out          = new DataOutputStream(clientSocket.getOutputStream()); 
  } // Verbindung
  
  /** 
   *  Liest aus dem Socket den Request aus und liefert 
   *  einen Request zurck. 
   *
   *  @exception RequestException wenn der request nicht vollstndig gelesen werden konnte
   *  @see Request
   *  @see Verbindung
   */
  public Request leseRequest() throws RequestException { 
    Request r = new Request();
    String headerLine;
    try {
      headerLine = in.readLine();
      r.setRequestLine(headerLine);
      while (r.isReceivingHead()) {             
          headerLine = in.readLine();
          r.addHeaderLine( headerLine );
      }
      if (r.isReceivingEntity()) {
        // Hier wre der Empfang eines Entities aus dem 
        // Request zu implementieren.
        // Da jedoch nur die GET-Methode implementiert werden soll,
        // entfllt dies.
      }
      System.out.println("----------------------------");
      System.out.println("Request von: " + 
                         clientSocket.getInetAddress().getHostAddress() + 
                         " " + r.getRequestLine() );
      
    } catch (IOException e) {
      // Verbindung abgebrochen whrend request eingelesen
      // werden sollte.
      // Kann vorkommen, wenn z.B. der Client die Verbindung
      // beendet.
      throw new RequestException("500");
    }
    
    return r;
  } // leseRequest
  
  /**
   *  Sendet eine Antwort, die durch das bergebene Response-
   *  objekt dargestellt ist.
   *  
   *  @param response Die Antwort, die gesendet werden soll
   */
  public void send( Response response ) throws SendException {
    response.write( out );
  }
  
  /**
   * Schliet die Verbindung
   */
  public void close() throws IOException {
    out.close();
    in.close();
    clientSocket.close();
  } // close
  
} // Verbindung