package httpServer;

import java.io.*;
import java.net.*;
import java.text.*;
import java.util.*;

import socketVerbindung.*;

/**
 * Diese Klasse implementiert einen einfachen HTTP/1.0-Server.
 * Bisher ist nur die GET-Methode implementiert.
 * Grundlasge ist der RFC 1945
 *
 * @author  Thorsten Fischer
 * @version 1.0, 30.05.2000
 */
public class Server {
    
  /** Die Instanz des Servers */
  private static Server serv = null;    
        
  /** Auf diesem Port lauscht der Server */
  private static int port = 80;
  
  /** Solange true, luft der Server */
  private boolean lauschen = true;
  
  /** 
   * Der http_URL fr diesen Server (RFC 1945 3.2.2)<BR>
   * z.B.: "http://127.0.0.1:8080"
   */
  public static String URL = "";
  
  /** RFC 1945 10.14 Serversoftware-id */
  public static final String SERVER_TOKEN = "TF-WWWServer/1.0";
  
  /** Das Verzeichnis, in dem der Server liegt */
  public static String rootDir="";

  /** 
	 *  Der Server lauscht auf dem port auf eingehende Verbindungen
	 */
  private Server () {

    ServerSocket serverSocket = null;
    
    try {            
        rootDir = System.getProperty("user.dir"); // Falls kein Zugriff auf Systemproperties, beende das Programm
        serverSocket = new ServerSocket(port);        
        System.out.println("Der Server ist unter Port "+port+" gestartet.");
        URL = "http://"+
              InetAddress.getLocalHost().getHostAddress()+
              (port!=80?(":"+port):"");        
    } catch (Exception e) {            
        if (e instanceof UnknownHostException) {
          URL = "http://127.0.0.1"+
                (port!=80?(":"+port):"");        
        } else {
          System.out.println("Der Server konnte auf Port "+port+" nicht initialisiert werden.");            
          System.exit(-1); // beende das Programm
        }
    }
    System.out.println("Die Adresse ist:\n"+URL);

    while (lauschen) {
      Verbindung   verbindung   = null;
      Request      request      = null;
      Response     response     = new Response();

      try {            
          verbindung = new Verbindung(serverSocket); 
      } catch (IOException e) {            
          System.out.println("Verbindungsaufbau schlug fehl.");            
      }        
      
      try { 
        request = verbindung.leseRequest();
      } catch (RequestException e) {
        System.out.println("Der Request konnte nicht geparst werden.");
        response.setStatusLine( e.getMessage() );
        request = null;
      }

      response.setInhalt( request );
      
      try {
        verbindung.send( response );
      } catch (Exception e) {
        System.out.println("Response konnte nicht gesendet werden");
      }

      try {
        verbindung.close();        
      } catch (Exception e) {
        System.out.println("Verbindung konnte nicht geschlossen werden");
      }
    
    } // while (lauschen)
      
    try {
      serverSocket.close();    
    } catch (IOException e) {
      System.err.println("Der Server konnte nicht beendet werden.");
    }

  } // Server

  /**
   *  Einstiegspunkt des Programmes, erzeugt ein Server-Objekt
   *  Aufruf ber die Kommandozeile.
   *  Die Methode main bekommt als Parameter einen int-Wert
   *  bergeben, der die Port-Nummer darstellt, unter der
   *  der Server laufen soll. Fehlt diese Angabe, oder ist
   *  sie fehlerhaft, wird 80 angenommen.
   */
  public static void main(String[] args) { 
    if (args.length!=0) {
      try {
        port = Integer.parseInt(args[0]);
      } catch (NumberFormatException e) {
        System.out.println("Server wird unter Port 80 gestartet.");
      }
    }
    serv = new Server();
  } // main

} // class Server

