package httpServer;

import java.io.*;
import java.util.*;

import dateisystem.*;
import socketVerbindung.*;

/**
 * Diese Klasse stellt eine Response dar.
 *
 * @author  Thorsten Fischer
 * @version 1.0, 30.05.2000
 */
public class Response {
  
                                
  /** RFC 1945 6.1 */
  private String statusLine = null;
  /** RFC 1945 6 */
  private Vector header = new Vector();
  /** RFC 1945 6 und 7.2*/
  private Ressource res = null;
  
  
  /**
   *  Erzeugt die Statuszeile der Response = die erste Zeile
   *  (RFC 1945 6.1)
   */
  public synchronized void setStatusLine(String status) {
    statusLine = Http_1_0.HTTP_VERSION+
                 " "+status+" "+
                 Http_1_0.statusCode.get(status)+
                 Http_1_0.CRLF;
  }
  
  /** 
   * Erzeugt in der Response einen neuen Header (RFC 1945 4.2)
   * 
   * @param name field-name des Headers
   * @param value field-value des Headers
   */
  public synchronized void addHeader(String name, String value) {
    if (value != null) {
      header.addElement(name+":"+Http_1_0.SP+value+Http_1_0.CRLF);
    }
  }
  
  /**
   * Diese Methode implementiert die Response-Generierung als
   * Antwort auf einen "GET"-Request
   */
  private synchronized void setInhaltGET(Request request) {
      String resStatus = "200"; // mit diesem Wert wird die Status-Line generiert
      //////////////////////////////////////////
      // Bercksichtige die Header des Requests:
      String fv=null; // field-value des Headers
      //////////////////////////////////////////
      // general-Header (RFC 1945 4.3)
//    if ((fv=request.getHeaderValue("Date"))             !=null); // hier nicht betrachtet
//    if ((fv=request.getHeaderValue("Pragma"))           !=null); // hier nicht betrachtet
      //////////////////////////////////////////
      // request-Header (RFC 1945 5.2)
//    if ((fv=request.getHeaderValue("Authorization"))    !=null); // hier nicht betrachtet
//    if ((fv=request.getHeaderValue("From"))             !=null); // hier nicht betrachtet
      if ((fv=request.getHeaderValue("If-Modified-Since"))!=null) {
        // (RFC 1945 10.9)
        Date ifModifiedSince = Http_1_0.parseHTTPDate( fv );
        if (ifModifiedSince == null) {
          System.out.println("Unbekanntes Format im Header \"If-Modified-Since\": "+fv);
        } else {
          if (!res.getLastModified().after(ifModifiedSince)) {
            res = null; // keine Ressource mitschicken
            resStatus = "304";
          }
        }
      } // If-Modified-Since
//    if ((fv=request.getHeaderValue("Referer"))          !=null); // hier nicht betrachtet
//    if ((fv=request.getHeaderValue("User-Agent"))       !=null); // hier nicht betrachtet
      //////////////////////////////////////////
      // entity-Header (RFC 1945 7.1)
//    if ((fv=request.getHeaderValue("Allow"))            !=null); // hier nicht betrachtet
//    if ((fv=request.getHeaderValue("Content-Encoding")) !=null); // hier nicht betrachtet
//    if ((fv=request.getHeaderValue("Content-Length"))   !=null); // hier nicht betrachtet
//    if ((fv=request.getHeaderValue("Content-Type"))     !=null); // hier nicht betrachtet
//    if ((fv=request.getHeaderValue("Expires"))          !=null); // hier nicht betrachtet
//    if ((fv=request.getHeaderValue("Last-Modified"))    !=null); // hier nicht betrachtet
      
      //////////////////////////////////////////
      // Erzeuge die Header der Response: (RFC 1945 6)

      //////////////////////////////////////////
      // general-Header (RFC 1945 4.3)
      addHeader("Date", Http_1_0.getHttpDate( Http_1_0.DATE_FORMAT_RFC1123 )); // 10.6
//    addHeader("Pragma", ""); // hier nicht betrachtet
      //////////////////////////////////////////
      // response-Header (RFC 1945 6.2)
      if (res!=null) { // falls eine Ressource mitgeschickt wird:
        addHeader("Location",         res.getLocation());    // 10.11
      }
      addHeader("Server",           Server.SERVER_TOKEN);  // 10.14
//    addHeader("WWW-Authenticate", "");                   // hier nicht betrachtet
      
      
      //////////////////////////////////////////
      // entity-Header (RFC 1945 7.1)
//    addHeader("Content-Encoding", "");                // hier nicht betrachtet
//    addHeader("Expires", "");                         // hier nicht betrachtet
      addHeader("Allow", Http_1_0.getAllowedMethods()); // 10.1
      if (res!=null) {
        addHeader("Content-Length", ""+res.length());     // 10.4
        addHeader("Content-Type", res.getType());         // 10.5
        addHeader("Last-Modified", Http_1_0.getHttpDate(  
                                     res.getLastModified(),
                                     Http_1_0.DATE_FORMAT_RFC1123));
                                                        // 10.10
      }
       setStatusLine( resStatus );
  } // setInhaltGET
  
  /**
   * Diese Methode implementiert die Response-Generierung als
   * Antwort auf einen "HEAD"-Request
   */
  private synchronized void setInhaltHEAD(Request request) {
    // nicht zu implementieren
  }  

  /**
   * Diese Methode implementiert die Response-Generierung als
   * Antwort auf einen "POST"-Request
   */
  private synchronized void setInhaltPOST(Request request) {
    // nicht zu implementieren
  }  

  /**
   * Der Response wird mit den Werten belegt, die vom
   * bergebenen Request angefordert werden. Die Methode
   * Verzweigt je nach der Methode des Requests in 
   * die jeweiligen setInhaltXXX-Methoden dieser Klasse.
   *
   * @param request Der Request, auf den geantwortet werden soll.
   *
   * @see Request
   * @see Response#setInhaltGET
   */
  public synchronized void setInhalt( Request request ) {
    if (request==null) return; // Wenn kein Request, dann auch keine Response

    try {
      res = new Ressource(  Server.rootDir, request.getUri() );
    } catch (IOException e) {
      setStatusLine( e.getMessage() );
      return;
    }

    if (request.isHTTPVer(0, 9)) {
      // Der Request war ein Simple-Request (RFC 1945 5) also
      // Erzeuge Simple-Response (RFC 1945 6)
      setInhaltGET(request);
      statusLine = null;
      header     = null;
    } else if (request.isHTTPVer(1, 0)
              || request.isHTTPVer(1, 1) // nur zu Testzwecken!!!
              ) {
      // Erzeuge Full-Response
      if ( request.getMethod().equals("GET") ) 
        setInhaltGET(request);
      /*
      // hier nicht zu implmentieren!
      else if ( request.getMethod().equals("HEAD") )
        setInhaltHEAD(request);
      else if ( request.getMethod().equals("POST") )
        setInhaltPOST(request);
      */
    } else {
      // Protokollversion nicht untersttzt
      setStatusLine("501");
      header = null;
      res    = null;
    } // if 
  } // setInhalt
  
  /**
   * Schreibt den Inhalt der Response in den DataOutputStream 
   *
   * @param out Der <code>DataOutputStream</code>, in den die Response geschrieben wird
   * @exception SendException Wenn ein Fehler beim Senden auftrat
   */
  public void write(DataOutputStream out) throws SendException {
    System.out.println("Die Response:");
    try {
      if (statusLine != null) {
        System.out.print( statusLine );
        out.writeBytes( statusLine );
      }
      if (header != null) {
        for( int i=0; i<header.size(); i++) {
          System.out.print((String)header.elementAt(i));
          out.writeBytes((String)header.elementAt(i));
        }
        System.out.print(Http_1_0.CRLF);
        out.writeBytes(Http_1_0.CRLF);
      }
      if (res != null) {
        System.out.println("<ENTITY>");
        res.write( out );
      }
    } catch (IOException e) {
      e.printStackTrace();
      throw new SendException("An den Client konnte der Header nicht gesendet werden" );
    }
  } // write
   
} // Response 