package httpServer;

import java.util.*;
import java.text.*;

/**
 * Diese Klasse implementiert die ntigen Konstanten fr HTTP/1.0
 *
 * @author  Thorsten Fischer
 * @version 1.0, 30.05.2000
 */
public class Http_1_0 {
  
  /** Alle implementierten Methoden RFC 1945 5.1.1 (String) */
  public static Vector    method      = new Vector();

  /** 
   *  Keys: statusCodes nach RFC 1945 6.1.1 (String) <BR>
   *  Values: reason-phrases nach RFC 1956 6.1.1 (String)
   */
  public static Hashtable statusCode  = new Hashtable();

  /** RFC 1945 2.2 */
  public static final String    CRLF        = ""+((char)13)+((char)10);
  /** RFC 1945 2.2 */
  public static final String    SP          = ""+((char)32);
  /** RFC 1945 3.1 */
  public static final String    HTTP_VERSION = "HTTP/1.0";
  /** RFC 1945 3.3 */
  public static final String    DATE_FORMAT_RFC1123 = "EEE, dd MMM yyyy HH:mm:ss 'GMT'";
  /** RFC 1945 3.3 */
  public static final String    DATE_FORMAT_RFC850  = "EEEE, dd-MMM-yy HH:mm:ss 'GMT'";
  /** RFC 1945 3.3 */
  public static final String    DATE_FORMAT_ASCTIME = "EEE MMM dd HH:mm:ss yyyy";
  
  /** 
   * Initialisiert die Konstanten
   */
  static {
    statusCode.put( "200" , "OK");
    statusCode.put( "201" , "Created");
    statusCode.put( "202" , "Accepted");
    statusCode.put( "204" , "No Content");
    statusCode.put( "301" , "Moved Permanently");
    statusCode.put( "302" , "Moved Temporarily");
    statusCode.put( "304" , "Not Modified");
    statusCode.put( "400" , "Bad Request");
    statusCode.put( "401" , "Unauthorized");
    statusCode.put( "403" , "Forbidden");
    statusCode.put( "404" , "Not Found");
    statusCode.put( "500" , "Internal Server Error");
    statusCode.put( "501" , "Not Implemented");
    statusCode.put( "502" , "Bad Gateway");
    statusCode.put( "503" , "Service Unavailable");
    
    method.addElement("GET");
    /* es soll nur die GET-Methode implementiert werden */
    // method.addElement("HEAD"); 
    // method.addElement("POST");
    
  }
  
  /** 
   *  Diese Klasse wird nur ber ihrer statischen Felder und 
   *  Methoden benutzt.
   */
  private Http_1_0() {}

  /** 
   * Parst einen String in ein Datum (RFC 1945 3.3)
   *
   * @return ein <code>Date</code>-Objekt oder null, wenn das Parsen 
   *         fehlschlug
   * @param d Der String, der geparst werden soll
   */
  public static Date parseHTTPDate(String d) {
    SimpleDateFormat formatter = null;
    Date             ret       = null;
      // rfc1123-date
      formatter = new SimpleDateFormat (DATE_FORMAT_RFC1123, Locale.US );
      try {
        ret = formatter.parse(d);
      } catch (ParseException e) {
        ret = null;
      }
    if (ret == null) {
      // rfc850-date
      formatter = new SimpleDateFormat (DATE_FORMAT_RFC850 , Locale.US );
      try {
        ret = formatter.parse(d);
      } catch (ParseException e) {
        ret = null;
      }
    }
    if (ret == null) {
      // asctime-date
      formatter = new SimpleDateFormat (DATE_FORMAT_ASCTIME, Locale.US );
      try {
        ret = formatter.parse(d);
      } catch (ParseException e) {
        ret = null;
      }
    }
    return ret;
  } // parseDate

  /** 
   * Liefert das aktuelle Systemdatum als String im angegebenen Format
   * zurck. (RFC 1945 3.3)
   *
   * @param format Das Format, in dem das Datum zurckgegeben werden soll
   * @see Http_1_0#DATE_FORMAT_RFC1123
   * @see Http_1_0#DATE_FORMAT_RFC850
   * @see Http_1_0#DATE_FORMAT_ASCTIME
   */
  public static String getHttpDate(String format) {
     return getHttpDate(new Date(), format);
  } // getHttpDate(String)
  
  /** 
   * Liefert das Datum als String im angegebenen Format
   * zurck. (RFC 1945 3.3)
   *
   * @param d Das zu formatierende Datum
   * @param format Das Format, in dem das Datum zurckgegeben werden soll
   * @see Http_1_0#DATE_FORMAT_RFC1123
   * @see Http_1_0#DATE_FORMAT_RFC850
   * @see Http_1_0#DATE_FORMAT_ASCTIME
   */
  public static String getHttpDate( Date d, String format ) {
     return (new SimpleDateFormat(format, Locale.US)).format(d);
  } // getHttpDate(Date, String)
  
  /**
   * Gibt alle erlaubten Methoden durch Komma getrennt zurck.
   */
  public static String getAllowedMethods() {
    String ret="";
    for (int i=0; i<method.size(); i++ ) {
      ret += (String) method.elementAt(i)+", ";
    } 
    // ziehe berflssiges ", " wieder ab
    return (ret.substring(0,ret.length()-2));
  } // getAllowedMethods

} // http_1_0